/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver;

import com.xenoterracide.gradle.git.GitStatus;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RegExUtils;
import org.jspecify.annotations.Nullable;
import org.semver4j.Semver;

final class SemverBuilder {
    private static final String ALPHA = "alpha";
    private static final String SEMVER_DELIMITER = ".";
    private static final String ZERO = "0";
    private Semver semver;
    private boolean dirtyOut;
    private long preReleaseDistance;
    private long buildDistance;
    private @Nullable String uniqueShort;
    private @Nullable GitStatus status;
    private @Nullable String branch;

    SemverBuilder(Semver semver) {
        this.semver = semver;
    }

    static String semverJoin(String ... parts) {
        return String.join((CharSequence)SEMVER_DELIMITER, parts);
    }

    private void createPreRelease() {
        if (this.preReleaseDistance > 0L) {
            if (this.semver.getPreRelease().isEmpty()) {
                this.semver = this.semver.withIncPatch().withPreRelease(SemverBuilder.semverJoin(ALPHA, ZERO, Long.toString(this.preReleaseDistance)));
            } else {
                String preRelease = Stream.concat(this.semver.getPreRelease().stream(), Stream.of(Long.toString(this.preReleaseDistance))).collect(Collectors.joining(SEMVER_DELIMITER));
                this.semver = this.semver.withClearedPreRelease().withPreRelease(preRelease);
            }
        }
        if (this.semver.getMajor() == 0 && this.semver.getMinor() == 0 && this.semver.getPatch() == 0) {
            this.semver = this.semver.withPreRelease(SemverBuilder.semverJoin(ALPHA, ZERO, Long.toString(this.preReleaseDistance)));
        }
    }

    private Optional<String> createBuild() {
        if (this.preReleaseDistance > 0L) {
            Optional<String> optSha = Optional.ofNullable(this.uniqueShort);
            return optSha.map(sha -> {
                Optional<String> g = Optional.of("git");
                Optional<String> distance = Optional.of(this.buildDistance).map(l -> Long.toString(l));
                Optional<String> branch = Optional.ofNullable(this.branch);
                Optional<String> hasBranch = branch.map(b -> "branch");
                Optional<String> status = Optional.ofNullable(this.dirtyOut ? this.status : null).filter(s -> s == GitStatus.DIRTY).map(Object::toString);
                return Stream.of(hasBranch, branch, g, distance, optSha, status).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(SEMVER_DELIMITER));
            });
        }
        return Optional.empty();
    }

    SemverBuilder withDirtyOut(boolean dirtyOut) {
        this.dirtyOut = dirtyOut;
        return this;
    }

    SemverBuilder withUniqueShort(@Nullable String uniqueShort) {
        this.uniqueShort = uniqueShort;
        return this;
    }

    SemverBuilder withPreReleaseDistance(long distance) {
        this.preReleaseDistance = distance;
        return this;
    }

    SemverBuilder withBuildDistance(long distance) {
        this.buildDistance = distance;
        return this;
    }

    SemverBuilder withRemoteDistance(long remoteDistance) {
        this.preReleaseDistance = remoteDistance;
        return this;
    }

    SemverBuilder withGitStatus(GitStatus status) {
        this.status = status;
        return this;
    }

    SemverBuilder withBranch(@Nullable String branch) {
        this.branch = RegExUtils.replaceAll((String)branch, (String)"\\P{Alnum}", (String)"-");
        return this;
    }

    Semver build() {
        this.createPreRelease();
        this.createBuild().ifPresent(build -> {
            this.semver = this.semver.withBuild(build);
        });
        return this.semver;
    }
}

