/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends InputStream {
    private byte[] skipBuffer;
    private InputStream src;
    private OutputStream dst;

    public TeeInputStream(InputStream src, OutputStream dst) {
        this.src = src;
        this.dst = dst;
    }

    @Override
    public int read() throws IOException {
        byte[] b = this.skipBuffer();
        int n = this.read(b, 0, 1);
        return n == 1 ? b[0] & 0xFF : -1;
    }

    @Override
    public long skip(long count) throws IOException {
        long skipped = 0L;
        long cnt = count;
        byte[] b = this.skipBuffer();
        while (0L < cnt) {
            int n = this.src.read(b, 0, (int)Math.min((long)b.length, cnt));
            if (n <= 0) break;
            this.dst.write(b, 0, n);
            skipped += (long)n;
            cnt -= (long)n;
        }
        return skipped;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int n = this.src.read(b, off, len);
        if (n > 0) {
            this.dst.write(b, off, n);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        int n;
        byte[] b = this.skipBuffer();
        while ((n = this.src.read(b)) > 0) {
            this.dst.write(b, 0, n);
        }
        this.dst.close();
        this.src.close();
    }

    private byte[] skipBuffer() {
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[2048];
        }
        return this.skipBuffer;
    }
}

