/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport.resolver;

import com.xenoterracide.gradle.semver.jgit.errors.RepositoryNotFoundException;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.RepositoryCache;
import com.xenoterracide.gradle.semver.jgit.transport.resolver.RepositoryResolver;
import com.xenoterracide.gradle.semver.jgit.transport.resolver.ServiceNotEnabledException;
import com.xenoterracide.gradle.semver.jgit.util.FS;
import com.xenoterracide.gradle.semver.jgit.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileResolver<C>
implements RepositoryResolver<C> {
    private volatile boolean exportAll;
    private final Map<String, Repository> exports = new ConcurrentHashMap<String, Repository>();
    private final Collection<File> exportBase = new CopyOnWriteArrayList<File>();

    public FileResolver() {
    }

    public FileResolver(File basePath, boolean exportAll) {
        this();
        this.exportDirectory(basePath);
        this.setExportAll(exportAll);
    }

    @Override
    public Repository open(C req, String name) throws RepositoryNotFoundException, ServiceNotEnabledException {
        if (FileResolver.isUnreasonableName(name)) {
            throw new RepositoryNotFoundException(name);
        }
        Repository db = this.exports.get(StringUtils.nameWithDotGit(name));
        if (db != null) {
            db.incrementOpen();
            return db;
        }
        for (File base : this.exportBase) {
            File dir = RepositoryCache.FileKey.resolve(new File(base, name), FS.DETECTED);
            if (dir == null) continue;
            try {
                RepositoryCache.FileKey key = RepositoryCache.FileKey.exact(dir, FS.DETECTED);
                db = RepositoryCache.open(key, true);
            }
            catch (IOException e) {
                throw new RepositoryNotFoundException(name, (Throwable)e);
            }
            try {
                if (this.isExportOk(req, name, db)) {
                    return db;
                }
                throw new ServiceNotEnabledException();
            }
            catch (IOException | RuntimeException e) {
                db.close();
                throw new RepositoryNotFoundException(name, (Throwable)e);
            }
            catch (ServiceNotEnabledException e) {
                db.close();
                throw e;
            }
        }
        if (this.exportBase.size() == 1) {
            File dir = new File(this.exportBase.iterator().next(), name);
            throw new RepositoryNotFoundException(name, (Throwable)new RepositoryNotFoundException(dir));
        }
        throw new RepositoryNotFoundException(name);
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean export) {
        this.exportAll = export;
    }

    public void exportRepository(String name, Repository db) {
        this.exports.put(StringUtils.nameWithDotGit(name), db);
    }

    public void exportDirectory(File dir) {
        this.exportBase.add(dir);
    }

    protected boolean isExportOk(C req, String repositoryName, Repository db) throws IOException {
        if (this.isExportAll()) {
            return true;
        }
        if (db.getDirectory() != null) {
            return new File(db.getDirectory(), "git-daemon-export-ok").exists();
        }
        return false;
    }

    private static boolean isUnreasonableName(String name) {
        if (name.length() == 0) {
            return true;
        }
        if (name.indexOf(92) >= 0) {
            return true;
        }
        if (new File(name).isAbsolute()) {
            return true;
        }
        if (name.startsWith("../")) {
            return true;
        }
        if (name.contains("/../")) {
            return true;
        }
        if (name.contains("/./")) {
            return true;
        }
        return name.contains("//");
    }
}

