/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport;

import com.xenoterracide.gradle.semver.jgit.lib.Config;
import java.util.HashMap;
import java.util.Map;

public class UrlConfig {
    private static final String KEY_INSTEADOF = "insteadof";
    private static final String KEY_PUSHINSTEADOF = "pushinsteadof";
    private static final String SECTION_URL = "url";
    private final Config config;
    private Map<String, String> insteadOf;
    private Map<String, String> pushInsteadOf;

    public UrlConfig(Config config) {
        this.config = config;
    }

    public String replace(String url) {
        if (this.insteadOf == null) {
            this.insteadOf = this.load(KEY_INSTEADOF);
        }
        return this.replace(url, this.insteadOf);
    }

    public boolean hasPushReplacements() {
        if (this.pushInsteadOf == null) {
            this.pushInsteadOf = this.load(KEY_PUSHINSTEADOF);
        }
        return !this.pushInsteadOf.isEmpty();
    }

    public String replacePush(String url) {
        if (this.pushInsteadOf == null) {
            this.pushInsteadOf = this.load(KEY_PUSHINSTEADOF);
        }
        return this.replace(url, this.pushInsteadOf);
    }

    private Map<String, String> load(String key) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (String url : this.config.getSubsections(SECTION_URL)) {
            String[] stringArray = this.config.getStringList(SECTION_URL, url, key);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                replacements.put(prefix, url);
                ++n2;
            }
        }
        return replacements;
    }

    private String replace(String uri, Map<String, String> replacements) {
        Map.Entry<String, String> match = null;
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            if (match != null && ((String)match.getKey()).length() > replacement.getKey().length() || !uri.startsWith(replacement.getKey())) continue;
            match = replacement;
        }
        if (match != null) {
            return (String)match.getValue() + uri.substring(((String)match.getKey()).length());
        }
        return uri;
    }
}

