/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revplot;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.PersonIdent;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revplot.PlotCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevObject;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevSort;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevTag;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PlotWalk
extends RevWalk {
    private Map<AnyObjectId, Set<Ref>> additionalRefMap;
    private Map<AnyObjectId, Set<Ref>> reverseRefMap;
    private Repository repository;

    @Override
    public void dispose() {
        super.dispose();
        if (this.reverseRefMap != null) {
            this.reverseRefMap.clear();
            this.reverseRefMap = null;
        }
        if (this.additionalRefMap != null) {
            this.additionalRefMap.clear();
            this.additionalRefMap = null;
        }
        this.repository = null;
    }

    public PlotWalk(Repository repo) {
        super(repo);
        super.sort(RevSort.TOPO, true);
        this.additionalRefMap = new HashMap<AnyObjectId, Set<Ref>>();
        this.repository = repo;
    }

    public void addAdditionalRefs(Iterable<Ref> refs) throws IOException {
        for (Ref ref : refs) {
            Set<Ref> set = this.additionalRefMap.get(ref.getObjectId());
            if (set == null) {
                set = Collections.singleton(ref);
            } else {
                set = new HashSet<Ref>(set);
                set.add(ref);
            }
            this.additionalRefMap.put(ref.getObjectId(), set);
        }
    }

    @Override
    public void sort(RevSort s, boolean use) {
        if (s == RevSort.TOPO && !use) {
            throw new IllegalArgumentException(JGitText.get().topologicalSortRequired);
        }
        super.sort(s, use);
    }

    @Override
    protected RevCommit createCommit(AnyObjectId id) {
        return new PlotCommit(id);
    }

    @Override
    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        PlotCommit pc = (PlotCommit)super.next();
        if (pc != null) {
            pc.refs = this.getRefs(pc);
        }
        return pc;
    }

    private Ref[] getRefs(AnyObjectId commitId) throws IOException {
        Collection list;
        if (this.reverseRefMap == null) {
            this.reverseRefMap = this.repository.getAllRefsByPeeledObjectId();
            for (Map.Entry<AnyObjectId, Set<Ref>> entry : this.additionalRefMap.entrySet()) {
                Set<Ref> set = this.reverseRefMap.get(entry.getKey());
                Set<Ref> additional = entry.getValue();
                if (set != null) {
                    if (additional.size() == 1) {
                        additional = new HashSet<Ref>(additional);
                    }
                    additional.addAll(set);
                }
                this.reverseRefMap.put(entry.getKey(), additional);
            }
            this.additionalRefMap.clear();
            this.additionalRefMap = null;
        }
        if ((list = (Collection)this.reverseRefMap.get(commitId)) == null) {
            return PlotCommit.NO_REFS;
        }
        Ref[] tags = list.toArray(new Ref[0]);
        Arrays.sort(tags, new PlotRefComparator());
        return tags;
    }

    class PlotRefComparator
    implements Comparator<Ref> {
        PlotRefComparator() {
        }

        @Override
        public int compare(Ref o1, Ref o2) {
            int cmp;
            long t2;
            long t1;
            block5: {
                RevObject obj1 = PlotWalk.this.parseAny(o1.getObjectId());
                RevObject obj2 = PlotWalk.this.parseAny(o2.getObjectId());
                t1 = this.timeof(obj1);
                t2 = this.timeof(obj2);
                if (t1 <= t2) break block5;
                return -1;
            }
            try {
                if (t1 < t2) {
                    return 1;
                }
            }
            catch (IOException obj1) {
                // empty catch block
            }
            if ((cmp = this.kind(o1) - this.kind(o2)) == 0) {
                cmp = o1.getName().compareTo(o2.getName());
            }
            return cmp;
        }

        long timeof(RevObject o) {
            if (o instanceof RevCommit) {
                return (long)((RevCommit)o).getCommitTime() * 1000L;
            }
            if (o instanceof RevTag) {
                RevTag tag = (RevTag)o;
                try {
                    PlotWalk.this.parseBody(tag);
                }
                catch (IOException e) {
                    return 0L;
                }
                PersonIdent who = tag.getTaggerIdent();
                return who != null ? who.getWhenAsInstant().toEpochMilli() : 0L;
            }
            return 0L;
        }

        int kind(Ref r) {
            if (r.getName().startsWith("refs/tags/")) {
                return 0;
            }
            if (r.getName().startsWith("refs/heads/")) {
                return 1;
            }
            if (r.getName().startsWith("refs/remotes/")) {
                return 2;
            }
            return 3;
        }
    }
}

