/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.lib;

import com.xenoterracide.gradle.semver.jgit.annotations.NonNull;
import com.xenoterracide.gradle.semver.jgit.api.errors.CanceledException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.api.errors.UnsupportedSigningFormatException;
import com.xenoterracide.gradle.semver.jgit.lib.GpgConfig;
import com.xenoterracide.gradle.semver.jgit.lib.GpgSignature;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectBuilder;
import com.xenoterracide.gradle.semver.jgit.lib.PersonIdent;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.transport.CredentialsProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public interface Signer {
    default public void signObject(@NonNull Repository repository, @NonNull GpgConfig config, @NonNull ObjectBuilder object, @NonNull PersonIdent committer, String signingKey, CredentialsProvider credentialsProvider) throws CanceledException, IOException, UnsupportedSigningFormatException {
        try {
            object.setGpgSignature(this.sign(repository, config, object.build(), committer, signingKey, credentialsProvider));
        }
        catch (UnsupportedEncodingException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public GpgSignature sign(@NonNull Repository var1, @NonNull GpgConfig var2, byte[] var3, @NonNull PersonIdent var4, String var5, CredentialsProvider var6) throws CanceledException, IOException, UnsupportedSigningFormatException;

    public boolean canLocateSigningKey(@NonNull Repository var1, @NonNull GpgConfig var2, @NonNull PersonIdent var3, String var4, CredentialsProvider var5) throws CanceledException;
}

