/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.lib;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectInserter;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectLoader;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public abstract class ObjectDatabase
implements AutoCloseable {
    private static final Set<ObjectId> shallowCommits = Collections.emptySet();

    protected ObjectDatabase() {
    }

    public boolean exists() {
        return true;
    }

    public void create() throws IOException {
    }

    public abstract ObjectInserter newInserter();

    public abstract ObjectReader newReader();

    public Set<ObjectId> getShallowCommits() throws IOException {
        return shallowCommits;
    }

    public void setShallowCommits(Set<ObjectId> shallowCommits) throws IOException {
        if (!shallowCommits.isEmpty()) {
            throw new UnsupportedOperationException("Shallow commits expected to be empty.");
        }
    }

    @Override
    public abstract void close();

    public boolean has(AnyObjectId objectId) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectReader or = this.newReader();){
            return or.has(objectId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws IOException {
        return this.open(objectId, -1);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectReader or = this.newReader();){
            return or.open(objectId, typeHint);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ObjectDatabase newCachedDatabase() {
        return this;
    }

    public abstract long getApproximateObjectCount();
}

