/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.pack;

import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import java.io.IOException;
import java.io.OutputStream;

public class DeltaEncoder {
    private static final int MAX_V2_COPY = 65536;
    private static final int MAX_COPY_CMD_SIZE = 8;
    private static final int MAX_INSERT_DATA_SIZE = 127;
    private final OutputStream out;
    private final byte[] buf = new byte[32];
    private final int limit;
    private int size;

    public DeltaEncoder(OutputStream out, long baseSize, long resultSize) throws IOException {
        this(out, baseSize, resultSize, 0);
    }

    public DeltaEncoder(OutputStream out, long baseSize, long resultSize, int limit) throws IOException {
        this.out = out;
        this.limit = limit;
        this.writeVarint(baseSize);
        this.writeVarint(resultSize);
    }

    private void writeVarint(long sz) throws IOException {
        int p = 0;
        while (sz >= 128L) {
            this.buf[p++] = (byte)(0x80 | (int)sz & 0x7F);
            sz >>>= 7;
        }
        this.buf[p++] = (byte)((int)sz & 0x7F);
        this.size += p;
        if (this.limit == 0 || this.size < this.limit) {
            this.out.write(this.buf, 0, p);
        }
    }

    public int getSize() {
        return this.size;
    }

    public boolean insert(String text) throws IOException {
        return this.insert(Constants.encode(text));
    }

    public boolean insert(byte[] text) throws IOException {
        return this.insert(text, 0, text.length);
    }

    public boolean insert(byte[] text, int off, int cnt) throws IOException {
        int n;
        if (cnt <= 0) {
            return true;
        }
        if (this.limit != 0) {
            int hdrs = cnt / 127;
            if (cnt % 127 != 0) {
                ++hdrs;
            }
            if (this.limit < this.size + hdrs + cnt) {
                return false;
            }
        }
        do {
            n = Math.min(127, cnt);
            this.out.write((byte)n);
            this.out.write(text, off, n);
            off += n;
            this.size += 1 + n;
        } while ((cnt -= n) > 0);
        return true;
    }

    public boolean copy(long offset, int cnt) throws IOException {
        if (cnt == 0) {
            return true;
        }
        int p = 0;
        while (65536 < cnt) {
            p = this.encodeCopy(p, offset, 65536);
            offset += 65536L;
            cnt -= 65536;
            if (this.buf.length >= p + 8) continue;
            if (this.limit != 0 && this.limit < this.size + p) {
                return false;
            }
            this.out.write(this.buf, 0, p);
            this.size += p;
            p = 0;
        }
        p = this.encodeCopy(p, offset, cnt);
        if (this.limit != 0 && this.limit < this.size + p) {
            return false;
        }
        this.out.write(this.buf, 0, p);
        this.size += p;
        return true;
    }

    private int encodeCopy(int p, long offset, int cnt) {
        int cmd = 128;
        int cmdPtr = p++;
        byte b = (byte)(offset & 0xFFL);
        if (b != 0) {
            cmd |= 1;
            this.buf[p++] = b;
        }
        if ((b = (byte)(offset >>> 8 & 0xFFL)) != 0) {
            cmd |= 2;
            this.buf[p++] = b;
        }
        if ((b = (byte)(offset >>> 16 & 0xFFL)) != 0) {
            cmd |= 4;
            this.buf[p++] = b;
        }
        if ((b = (byte)(offset >>> 24 & 0xFFL)) != 0) {
            cmd |= 8;
            this.buf[p++] = b;
        }
        if (cnt != 65536) {
            b = (byte)(cnt & 0xFF);
            if (b != 0) {
                cmd |= 0x10;
                this.buf[p++] = b;
            }
            if ((b = (byte)(cnt >>> 8 & 0xFF)) != 0) {
                cmd |= 0x20;
                this.buf[p++] = b;
            }
            if ((b = (byte)(cnt >>> 16 & 0xFF)) != 0) {
                cmd |= 0x40;
                this.buf[p++] = b;
            }
        }
        this.buf[cmdPtr] = (byte)cmd;
        return p;
    }
}

