/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.transport.PackedObjectInfo;
import com.xenoterracide.gradle.semver.jgit.util.NB;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public abstract class PackObjectSizeIndexWriter {
    private static final int MAX_24BITS_UINT = 0xFFFFFF;
    private static final PackObjectSizeIndexWriter NULL_WRITER = new PackObjectSizeIndexWriter(){

        @Override
        public void write(List<? extends PackedObjectInfo> objs) {
        }
    };
    protected static final byte[] HEADER = new byte[]{-1, 115, 105, 122};

    public static PackObjectSizeIndexWriter createWriter(OutputStream os, int minSize) {
        if (minSize < 0) {
            return NULL_WRITER;
        }
        return new PackObjectSizeWriterV1(os, minSize);
    }

    public abstract void write(List<? extends PackedObjectInfo> var1) throws IOException;

    static class PackObjectSizeWriterV1
    extends PackObjectSizeIndexWriter {
        private final OutputStream os;
        private final int minObjSize;
        private final byte[] intBuffer = new byte[4];

        PackObjectSizeWriterV1(OutputStream os, int minSize) {
            this.os = new BufferedOutputStream(os);
            this.minObjSize = minSize;
        }

        @Override
        public void write(List<? extends PackedObjectInfo> allObjects) throws IOException {
            this.os.write(HEADER);
            this.writeUInt8(1);
            this.writeInt32(this.minObjSize);
            PackedObjectStats stats = this.countIndexableObjects(allObjects);
            int[] indexablePositions = this.findIndexablePositions(allObjects, stats.indexableObjs);
            this.writeInt32(indexablePositions.length);
            if (indexablePositions.length == 0) {
                this.os.flush();
                return;
            }
            if (stats.pos24Bits > 0) {
                this.writeUInt8(24);
                this.writeInt32(stats.pos24Bits);
                PackObjectSizeWriterV1.applyToRange(indexablePositions, 0, stats.pos24Bits, this::writeInt24);
            }
            if (stats.pos31Bits > 0) {
                this.writeUInt8(32);
                this.writeInt32(stats.pos31Bits);
                PackObjectSizeWriterV1.applyToRange(indexablePositions, stats.pos24Bits, stats.pos24Bits + stats.pos31Bits, this::writeInt32);
            }
            this.writeUInt8(0);
            this.writeSizes(allObjects, indexablePositions, stats.sizeOver2GB);
            this.os.flush();
        }

        private void writeUInt8(int i) throws IOException {
            if (i > 255) {
                throw new IllegalStateException(JGitText.get().numberDoesntFit);
            }
            NB.encodeInt32(this.intBuffer, 0, i);
            this.os.write(this.intBuffer, 3, 1);
        }

        private void writeInt24(int i) throws IOException {
            NB.encodeInt24(this.intBuffer, 1, i);
            this.os.write(this.intBuffer, 1, 3);
        }

        private void writeInt32(int i) throws IOException {
            NB.encodeInt32(this.intBuffer, 0, i);
            this.os.write(this.intBuffer);
        }

        private void writeSizes(List<? extends PackedObjectInfo> allObjects, int[] indexablePositions, int objsBiggerThan2Gb) throws IOException {
            if (indexablePositions.length == 0) {
                this.writeInt32(0);
                return;
            }
            byte[] sizes64bits = new byte[8 * objsBiggerThan2Gb];
            int s64 = 0;
            int i = 0;
            while (i < indexablePositions.length) {
                PackedObjectInfo info = allObjects.get(indexablePositions[i]);
                if (info.getFullSize() < Integer.MAX_VALUE) {
                    this.writeInt32((int)info.getFullSize());
                } else {
                    this.writeInt32(-1 * (s64 + 1));
                    NB.encodeInt64(sizes64bits, s64 * 8, info.getFullSize());
                    ++s64;
                }
                ++i;
            }
            if (objsBiggerThan2Gb > 0) {
                this.writeInt32(objsBiggerThan2Gb);
                this.os.write(sizes64bits);
            }
            this.writeInt32(0);
        }

        private int[] findIndexablePositions(List<? extends PackedObjectInfo> allObjects, int indexableObjs) {
            int[] positions = new int[indexableObjs];
            int positionIdx = 0;
            int i = 0;
            while (i < allObjects.size()) {
                PackedObjectInfo o = allObjects.get(i);
                if (this.shouldIndex(o)) {
                    positions[positionIdx++] = i;
                }
                ++i;
            }
            return positions;
        }

        private PackedObjectStats countIndexableObjects(List<? extends PackedObjectInfo> objs) {
            PackedObjectStats stats = new PackedObjectStats();
            int i = 0;
            while (i < objs.size()) {
                PackedObjectInfo o = objs.get(i);
                if (this.shouldIndex(o)) {
                    ++stats.indexableObjs;
                    if (o.getFullSize() > Integer.MAX_VALUE) {
                        ++stats.sizeOver2GB;
                    }
                    if (i <= 0xFFFFFF) {
                        ++stats.pos24Bits;
                    } else {
                        ++stats.pos31Bits;
                    }
                }
                ++i;
            }
            return stats;
        }

        private boolean shouldIndex(PackedObjectInfo o) {
            return o.getType() == 3 && o.getFullSize() >= (long)this.minObjSize;
        }

        private static void applyToRange(int[] allPositions, int start, int end, IntEncoder encoder) throws IOException {
            int i = start;
            while (i < end) {
                encoder.encode(allPositions[i]);
                ++i;
            }
        }

        @FunctionalInterface
        static interface IntEncoder {
            public void encode(int var1) throws IOException;
        }

        private static class PackedObjectStats {
            int indexableObjs;
            int pos24Bits;
            int pos31Bits;
            int sizeOver2GB;

            private PackedObjectStats() {
            }
        }
    }
}

