/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph;

import com.xenoterracide.gradle.semver.jgit.annotations.NonNull;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectIdOwnerMap;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectReader;
import com.xenoterracide.gradle.semver.jgit.lib.ProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevObject;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevSort;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.util.BlockList;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GraphCommits
implements Iterable<RevCommit> {
    private final List<RevCommit> sortedCommits;
    private final ObjectIdOwnerMap<CommitWithPosition> commitPosMap;
    private final int extraEdgeCnt;
    private final ObjectReader objectReader;

    public static GraphCommits fromWalk(ProgressMonitor pm, @NonNull Set<? extends ObjectId> wants, @NonNull RevWalk walk) throws IOException {
        RevCommit c;
        walk.reset();
        walk.sort(RevSort.NONE);
        walk.setRetainBody(false);
        for (ObjectId objectId : wants) {
            RevObject o = walk.parseAny(objectId);
            if (!(o instanceof RevCommit)) continue;
            walk.markStart((RevCommit)o);
        }
        BlockList<RevCommit> blockList = new BlockList<RevCommit>();
        pm.beginTask(JGitText.get().findingCommitsForCommitGraph, 0);
        while ((c = walk.next()) != null) {
            pm.update(1);
            blockList.add(c);
        }
        pm.endTask();
        return new GraphCommits(blockList, walk.getObjectReader());
    }

    private GraphCommits(List<RevCommit> commits, ObjectReader objectReader) {
        Collections.sort(commits);
        this.sortedCommits = commits;
        this.commitPosMap = new ObjectIdOwnerMap();
        int cnt = 0;
        int i = 0;
        while (i < commits.size()) {
            RevCommit c = this.sortedCommits.get(i);
            if (c.getParentCount() > 2) {
                cnt += c.getParentCount() - 1;
            }
            this.commitPosMap.add(new CommitWithPosition(c, i));
            ++i;
        }
        this.extraEdgeCnt = cnt;
        this.objectReader = objectReader;
    }

    int getOidPosition(RevCommit c) throws MissingObjectException {
        CommitWithPosition commitWithPosition = this.commitPosMap.get(c);
        if (commitWithPosition == null) {
            throw new MissingObjectException((ObjectId)c, 1);
        }
        return commitWithPosition.position;
    }

    int getExtraEdgeCnt() {
        return this.extraEdgeCnt;
    }

    int size() {
        return this.sortedCommits.size();
    }

    ObjectReader getObjectReader() {
        return this.objectReader;
    }

    @Override
    public Iterator<RevCommit> iterator() {
        return this.sortedCommits.iterator();
    }

    private static class CommitWithPosition
    extends ObjectIdOwnerMap.Entry {
        final int position;

        CommitWithPosition(AnyObjectId id, int position) {
            super(id);
            this.position = position;
        }
    }
}

