/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.attributes;

import com.xenoterracide.gradle.semver.jgit.attributes.Attribute;
import com.xenoterracide.gradle.semver.jgit.errors.InvalidPatternException;
import com.xenoterracide.gradle.semver.jgit.ignore.IMatcher;
import com.xenoterracide.gradle.semver.jgit.ignore.internal.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AttributesRule {
    private static final String ATTRIBUTES_SPLIT_REGEX = "[ \t\r]";
    private final String pattern;
    private final List<Attribute> attributes;
    private final boolean nameOnly;
    private final boolean dirOnly;
    private final IMatcher matcher;

    private static List<Attribute> parseAttributes(String attributesLine) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        String[] stringArray = attributesLine.split(ATTRIBUTES_SPLIT_REGEX);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if ((attribute = attribute.trim()).length() != 0) {
                if (attribute.startsWith("-")) {
                    if (attribute.length() > 1) {
                        result.add(new Attribute(attribute.substring(1), Attribute.State.UNSET));
                    }
                } else if (attribute.startsWith("!")) {
                    if (attribute.length() > 1) {
                        result.add(new Attribute(attribute.substring(1), Attribute.State.UNSPECIFIED));
                    }
                } else {
                    int equalsIndex = attribute.indexOf(61);
                    if (equalsIndex == -1) {
                        result.add(new Attribute(attribute, Attribute.State.SET));
                    } else {
                        String attributeKey = attribute.substring(0, equalsIndex);
                        if (attributeKey.length() > 0) {
                            String attributeValue = attribute.substring(equalsIndex + 1);
                            result.add(new Attribute(attributeKey, attributeValue));
                        }
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    public AttributesRule(String pattern, String attributes) {
        this.attributes = AttributesRule.parseAttributes(attributes);
        if (((String)pattern).endsWith("/")) {
            pattern = ((String)pattern).substring(0, ((String)pattern).length() - 1);
            this.dirOnly = true;
        } else {
            this.dirOnly = false;
        }
        int slashIndex = ((String)pattern).indexOf(47);
        if (slashIndex < 0) {
            this.nameOnly = true;
        } else if (slashIndex == 0) {
            this.nameOnly = false;
        } else {
            this.nameOnly = false;
            pattern = "/" + (String)pattern;
        }
        IMatcher candidateMatcher = IMatcher.NO_MATCH;
        try {
            candidateMatcher = PathMatcher.createPathMatcher((String)pattern, Character.valueOf('/'), this.dirOnly);
        }
        catch (InvalidPatternException invalidPatternException) {
            // empty catch block
        }
        this.matcher = candidateMatcher;
        this.pattern = pattern;
    }

    public boolean isDirOnly() {
        return this.dirOnly;
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isMatch(String relativeTarget, boolean isDirectory) {
        if (relativeTarget == null) {
            return false;
        }
        if (relativeTarget.length() == 0) {
            return false;
        }
        boolean match = this.matcher.matches(relativeTarget, isDirectory, true);
        return match;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pattern);
        for (Attribute a : this.attributes) {
            sb.append(" ");
            sb.append(a);
        }
        return sb.toString();
    }
}

