/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.CloneCommand;
import com.xenoterracide.gradle.semver.jgit.api.FetchCommand;
import com.xenoterracide.gradle.semver.jgit.api.Git;
import com.xenoterracide.gradle.semver.jgit.api.MergeCommand;
import com.xenoterracide.gradle.semver.jgit.api.RebaseCommand;
import com.xenoterracide.gradle.semver.jgit.api.TransportCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.CheckoutConflictException;
import com.xenoterracide.gradle.semver.jgit.api.errors.ConcurrentRefUpdateException;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.InvalidConfigurationException;
import com.xenoterracide.gradle.semver.jgit.api.errors.InvalidMergeHeadsException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.api.errors.NoHeadException;
import com.xenoterracide.gradle.semver.jgit.api.errors.NoMessageException;
import com.xenoterracide.gradle.semver.jgit.api.errors.RefNotFoundException;
import com.xenoterracide.gradle.semver.jgit.api.errors.WrongRepositoryStateException;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCacheCheckout;
import com.xenoterracide.gradle.semver.jgit.errors.ConfigInvalidException;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.LockFile;
import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import com.xenoterracide.gradle.semver.jgit.lib.ProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.lib.RefUpdate;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.merge.MergeStrategy;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.submodule.SubmoduleWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.PathFilterGroup;
import com.xenoterracide.gradle.semver.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private CloneCommand.Callback callback;
    private FetchCommand.Callback fetchCallback;
    private boolean fetch = false;
    private boolean clonedRestored;

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    private static boolean submoduleExists(File gitDir) {
        if (gitDir != null && gitDir.isDirectory()) {
            File[] files = gitDir.listFiles();
            return files != null && files.length != 0;
        }
        return false;
    }

    private static void restoreSubmodule(File gitDir, File workingTree) throws IOException {
        LockFile dotGitLock = new LockFile(new File(workingTree, ".git"));
        if (dotGitLock.lock()) {
            String content = "gitdir: " + SubmoduleUpdateCommand.getRelativePath(gitDir, workingTree);
            dotGitLock.write(Constants.encode(content));
            dotGitLock.commit();
        }
    }

    private static String getRelativePath(File gitDir, File workingTree) {
        File relPath;
        try {
            relPath = workingTree.toPath().relativize(gitDir.toPath()).toFile();
        }
        catch (IllegalArgumentException e) {
            relPath = gitDir;
        }
        return FileUtils.pathToString(relPath);
    }

    private String determineUpdateMode(String mode) {
        if (this.clonedRestored) {
            return "checkout";
        }
        return mode;
    }

    private Repository getOrCloneSubmodule(SubmoduleWalk generator, String url) throws IOException, GitAPIException {
        Repository repository = generator.getRepository();
        boolean restored = false;
        boolean cloned = false;
        if (repository == null) {
            File gitDir = new File(new File(this.repo.getCommonDirectory(), "modules"), generator.getPath());
            if (SubmoduleUpdateCommand.submoduleExists(gitDir)) {
                SubmoduleUpdateCommand.restoreSubmodule(gitDir, generator.getDirectory());
                restored = true;
                this.clonedRestored = true;
                repository = generator.getRepository();
            } else {
                if (this.callback != null) {
                    this.callback.cloningSubmodule(generator.getPath());
                }
                CloneCommand clone = Git.cloneRepository();
                this.configure(clone);
                clone.setURI(url);
                clone.setDirectory(generator.getDirectory());
                clone.setGitDir(gitDir);
                clone.setRelativePaths(true);
                if (this.monitor != null) {
                    clone.setProgressMonitor(this.monitor);
                }
                repository = clone.call().getRepository();
                cloned = true;
                this.clonedRestored = true;
            }
        }
        if ((this.fetch || restored) && !cloned) {
            if (this.fetchCallback != null) {
                this.fetchCallback.fetchingSubmodule(generator.getPath());
            }
            FetchCommand fetchCommand = Git.wrap(repository).fetch();
            if (this.monitor != null) {
                fetchCommand.setProgressMonitor(this.monitor);
            }
            this.configure(fetchCommand);
            fetchCommand.call();
        }
        return repository;
    }

    @Override
    public Collection<String> call() throws InvalidConfigurationException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException, NoHeadException, RefNotFoundException, GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                ArrayList<String> updated = new ArrayList<String>();
                while (generator.next()) {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    this.clonedRestored = false;
                    Throwable throwable2 = null;
                    Object var7_12 = null;
                    try {
                        Repository submoduleRepo = this.getOrCloneSubmodule(generator, url);
                        try {
                            try (RevWalk walk = new RevWalk(submoduleRepo);){
                                RevCommit commit = walk.parseCommit(generator.getObjectId());
                                String update = this.determineUpdateMode(generator.getConfigUpdate());
                                if ("merge".equals(update)) {
                                    MergeCommand merge = new MergeCommand(submoduleRepo);
                                    merge.include(commit);
                                    merge.setProgressMonitor(this.monitor);
                                    merge.setStrategy(this.strategy);
                                    merge.call();
                                } else if ("rebase".equals(update)) {
                                    RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                                    rebase.setUpstream(commit);
                                    rebase.setProgressMonitor(this.monitor);
                                    rebase.setStrategy(this.strategy);
                                    rebase.call();
                                } else {
                                    DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                                    co.setFailOnConflict(true);
                                    co.setProgressMonitor(this.monitor);
                                    co.checkout();
                                    RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                                    refUpdate.setNewObjectId(commit);
                                    refUpdate.forceUpdate();
                                    if (this.callback != null) {
                                        this.callback.checkingOut(commit, generator.getPath());
                                    }
                                }
                            }
                            if (submoduleRepo != null) {
                                submoduleRepo.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (submoduleRepo != null) {
                                submoduleRepo.close();
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                    updated.add(generator.getPath());
                }
                return updated;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SubmoduleUpdateCommand setCallback(CloneCommand.Callback callback) {
        this.callback = callback;
        return this;
    }

    public SubmoduleUpdateCommand setFetchCallback(FetchCommand.Callback callback) {
        this.fetchCallback = callback;
        return this;
    }
}

