/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.ReflogCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.InvalidRefNameException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.ReflogEntry;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class StashListCommand
extends GitCommand<Collection<RevCommit>> {
    public StashListCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<RevCommit> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            if (this.repo.exactRef("refs/stash") == null) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
        ReflogCommand refLog = new ReflogCommand(this.repo);
        refLog.setRef("refs/stash");
        Object stashEntries = refLog.call();
        if (stashEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RevCommit> stashCommits = new ArrayList<RevCommit>(stashEntries.size());
        Throwable throwable = null;
        Object var5_7 = null;
        try (RevWalk walk = new RevWalk(this.repo);){
            Iterator iterator = stashEntries.iterator();
            while (iterator.hasNext()) {
                ReflogEntry entry = (ReflogEntry)iterator.next();
                try {
                    stashCommits.add(walk.parseCommit(entry.getNewId()));
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, entry.getNewId()), e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return stashCommits;
    }
}

