/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.StoredConfig;
import com.xenoterracide.gradle.semver.jgit.transport.RefSpec;
import com.xenoterracide.gradle.semver.jgit.transport.RemoteConfig;
import com.xenoterracide.gradle.semver.jgit.transport.URIish;
import java.io.IOException;
import java.net.URISyntaxException;

public class RemoteAddCommand
extends GitCommand<RemoteConfig> {
    private String name;
    private URIish uri;

    protected RemoteAddCommand(Repository repo) {
        super(repo);
    }

    public RemoteAddCommand setName(String name) {
        this.name = name;
        return this;
    }

    public RemoteAddCommand setUri(URIish uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.name);
            RefSpec refSpec = new RefSpec();
            refSpec = refSpec.setForceUpdate(true);
            refSpec = refSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + this.name + "/*");
            remote.addFetchRefSpec(refSpec);
            remote.addURI(this.uri);
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

