/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.InvalidRefNameException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.api.errors.RefAlreadyExistsException;
import com.xenoterracide.gradle.semver.jgit.api.errors.RefNotFoundException;
import com.xenoterracide.gradle.semver.jgit.errors.AmbiguousObjectException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.RefUpdate;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.StoredConfig;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.text.MessageFormat;

public class CreateBranchCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private SetupUpstreamMode upstreamMode;
    private String startPoint = "HEAD";
    private RevCommit startCommit;

    protected CreateBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        this.checkCallable();
        this.processOptions();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                String autosetupflag;
                String refLogMessage;
                Ref baseRef;
                boolean exists;
                boolean bl = exists = this.repo.findRef("refs/heads/" + this.name) != null;
                if (!this.force && exists) {
                    throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists1, this.name));
                }
                ObjectId startAt = this.getStartPointObjectId();
                String startPointFullName = null;
                if (this.startPoint != null && (baseRef = this.repo.findRef(this.startPoint)) != null) {
                    startPointFullName = baseRef.getName();
                }
                String baseBranch = "";
                if (startPointFullName == null) {
                    String baseCommit;
                    if (this.startCommit != null) {
                        baseCommit = this.startCommit.getShortMessage();
                    } else {
                        RevCommit commit = revWalk.parseCommit(this.repo.resolve(this.getStartPointOrHead()));
                        baseCommit = commit.getShortMessage();
                    }
                    refLogMessage = exists ? "branch: Reset start-point to commit " + baseCommit : "branch: Created from commit " + baseCommit;
                } else if (startPointFullName.startsWith("refs/heads/") || startPointFullName.startsWith("refs/remotes/")) {
                    baseBranch = startPointFullName;
                    refLogMessage = exists ? "branch: Reset start-point to branch " + startPointFullName : "branch: Created from branch " + baseBranch;
                } else {
                    startAt = revWalk.peel(revWalk.parseAny(startAt));
                    refLogMessage = exists ? "branch: Reset start-point to tag " + startPointFullName : "branch: Created from tag " + startPointFullName;
                }
                RefUpdate updateRef = this.repo.updateRef("refs/heads/" + this.name);
                updateRef.setNewObjectId(startAt);
                updateRef.setRefLogMessage(refLogMessage, false);
                RefUpdate.Result updateResult = exists && this.force ? updateRef.forceUpdate() : updateRef.update();
                this.setCallable(false);
                boolean ok = false;
                switch (updateResult) {
                    case NEW: {
                        ok = !exists;
                        break;
                    }
                    case NO_CHANGE: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        ok = exists;
                        break;
                    }
                }
                if (!ok) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().createBranchUnexpectedResult, updateResult.name()));
                }
                Ref result = this.repo.findRef(this.name);
                if (result == null) {
                    throw new JGitInternalException(JGitText.get().createBranchFailedUnknownReason);
                }
                if (baseBranch.length() == 0) {
                    return result;
                }
                boolean doConfigure = this.upstreamMode == SetupUpstreamMode.SET_UPSTREAM || this.upstreamMode == SetupUpstreamMode.TRACK ? true : (this.upstreamMode == SetupUpstreamMode.NOTRACK ? false : ("false".equals(autosetupflag = this.repo.getConfig().getString("branch", null, "autosetupmerge")) ? false : ("always".equals(autosetupflag) ? true : baseBranch.startsWith("refs/remotes/"))));
                if (doConfigure) {
                    StoredConfig config = this.repo.getConfig();
                    String remoteName = this.repo.getRemoteName(baseBranch);
                    if (remoteName != null) {
                        String branchName = this.repo.shortenRemoteBranchName(baseBranch);
                        config.setString("branch", this.name, "remote", remoteName);
                        config.setString("branch", this.name, "merge", "refs/heads/" + branchName);
                    } else {
                        config.setString("branch", this.name, "remote", ".");
                        config.setString("branch", this.name, "merge", baseBranch);
                    }
                    config.save();
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    private ObjectId getStartPointObjectId() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        String startPointOrHead = this.getStartPointOrHead();
        ObjectId result = this.repo.resolve(startPointOrHead);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, startPointOrHead));
        }
        return result;
    }

    private String getStartPointOrHead() {
        return this.startPoint != null ? this.startPoint : "HEAD";
    }

    private void processOptions() throws InvalidRefNameException {
        if (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name) || !CreateBranchCommand.isValidBranchName(this.name)) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
    }

    public static boolean isValidBranchName(String branchName) {
        if ("HEAD".equals(branchName)) {
            return false;
        }
        return !branchName.startsWith("-");
    }

    public CreateBranchCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public CreateBranchCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public CreateBranchCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        return this;
    }

    public CreateBranchCommand setStartPoint(RevCommit startPoint) {
        this.checkCallable();
        this.startCommit = startPoint;
        this.startPoint = null;
        return this;
    }

    public CreateBranchCommand setUpstreamMode(SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    public static enum SetupUpstreamMode {
        TRACK,
        NOTRACK,
        SET_UPSTREAM;

    }
}

