/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.merge.ResolveMerger;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import java.util.List;
import java.util.Map;

public class CherryPickResult {
    private final CherryPickStatus status;
    private final RevCommit newHead;
    private final List<Ref> cherryPickedRefs;
    private final Map<String, ResolveMerger.MergeFailureReason> failingPaths;
    public static final CherryPickResult CONFLICT = new CherryPickResult(CherryPickStatus.CONFLICTING);

    public CherryPickResult(RevCommit newHead, List<Ref> cherryPickedRefs) {
        this.status = CherryPickStatus.OK;
        this.newHead = newHead;
        this.cherryPickedRefs = cherryPickedRefs;
        this.failingPaths = null;
    }

    public CherryPickResult(Map<String, ResolveMerger.MergeFailureReason> failingPaths) {
        this.status = CherryPickStatus.FAILED;
        this.newHead = null;
        this.cherryPickedRefs = null;
        this.failingPaths = failingPaths;
    }

    private CherryPickResult(CherryPickStatus status) {
        this.status = status;
        this.newHead = null;
        this.cherryPickedRefs = null;
        this.failingPaths = null;
    }

    public CherryPickStatus getStatus() {
        return this.status;
    }

    public RevCommit getNewHead() {
        return this.newHead;
    }

    public List<Ref> getCherryPickedRefs() {
        return this.cherryPickedRefs;
    }

    public Map<String, ResolveMerger.MergeFailureReason> getFailingPaths() {
        return this.failingPaths;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CherryPickStatus {
        OK{

            public String toString() {
                return "Ok";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "Failed";
            }
        }
        ,
        CONFLICTING{

            public String toString() {
                return "Conflicting";
            }
        };

    }
}

