/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.git;

import com.xenoterracide.gradle.git.GitRemote;
import com.xenoterracide.gradle.git.ProvidedFactory;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.jspecify.annotations.Nullable;

public class GitRemoteForGradle
implements GitRemote {
    private final ProvidedFactory pf;
    private final String name;
    private final Provider<String> headBranch;
    private final Provider<String> headBranchRefName;

    GitRemoteForGradle(ProvidedFactory pf, GitRemote remote) {
        this.name = remote.name();
        this.headBranch = pf.providedString(remote::headBranch);
        this.headBranchRefName = pf.providedString(remote::headBranchRefName);
        this.pf = pf;
    }

    public String getName() {
        return this.name;
    }

    public Provider<String> getHeadBranch() {
        return this.headBranch.orElse(this.pf.providedString(() -> {
            Logging.getLogger(this.getClass()).warn("Git remote {} has no HEAD branch; run `git remote set-head {} --auto`", (Object)this.name, (Object)this.name);
            return null;
        }));
    }

    Provider<String> getHeadBranchRefName() {
        return this.headBranchRefName;
    }

    @Override
    public @Nullable String headBranchRefName() {
        return (String)this.headBranchRefName.getOrNull();
    }

    @Override
    public String name() {
        return this.name;
    }
}

