/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci.workflow;

import com.google.inject.Inject;
import com.xebialabs.xlrelease.ci.Credential;
import com.xebialabs.xlrelease.ci.Messages;
import com.xebialabs.xlrelease.ci.NameValuePair;
import com.xebialabs.xlrelease.ci.RepositoryUtils;
import com.xebialabs.xlrelease.ci.XLReleaseNotifier;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnector;
import com.xebialabs.xlrelease.ci.util.JenkinsReleaseListener;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class XLReleaseStep
extends AbstractStepImpl {
    public final String serverCredentials;
    public final String template;
    public final String releaseTitle;
    @Deprecated
    public String version;
    public List<NameValuePair> variables = null;
    public boolean startRelease = false;
    public String overrideCredentialId;

    @DataBoundConstructor
    public XLReleaseStep(String serverCredentials, String template, String version, List<NameValuePair> variables, boolean startRelease, String releaseTitle) {
        this.serverCredentials = serverCredentials;
        this.template = template;
        this.version = version;
        this.variables = variables;
        this.startRelease = startRelease;
        this.releaseTitle = releaseTitle;
    }

    @DataBoundSetter
    public void setVersion(String version) {
        this.version = Util.fixEmptyAndTrim((String)version);
    }

    @DataBoundSetter
    public void setOverrideCredentialId(String overrideCredentialId) {
        this.overrideCredentialId = overrideCredentialId;
    }

    @DataBoundSetter
    public void setVariables(List<NameValuePair> variables) {
        this.variables = variables;
    }

    @DataBoundSetter
    public void setStartRelease(boolean startRelease) {
        this.startRelease = startRelease;
    }

    public XLReleaseStepDescriptor getDescriptor() {
        return (XLReleaseStepDescriptor)super.getDescriptor();
    }

    public static final class XLReleaseExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        @Inject
        private transient XLReleaseStep step;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run<?, ?> run;

        protected Void run() throws Exception {
            if (StringUtils.isNotEmpty((String)this.step.version)) {
                JenkinsReleaseListener deploymentListener = new JenkinsReleaseListener(this.listener);
                deploymentListener.info(Messages._XLReleaseStep_versionDeprecated());
            }
            Job job = this.run.getParent();
            XLReleaseNotifier releaseNotifier = new XLReleaseNotifier(this.step.serverCredentials, this.step.template, this.step.releaseTitle != null ? this.step.releaseTitle : this.step.version, this.step.variables, this.step.startRelease, this.getOverridingCredential());
            XLReleaseServerConnector xlReleaseServerConnector = RepositoryUtils.getXLreleaseServerFromCredentialsId(this.step.serverCredentials, this.step.overrideCredentialId, job);
            releaseNotifier.executeRelease(this.envVars, this.listener, xlReleaseServerConnector);
            return null;
        }

        private Credential getOverridingCredential() {
            if (StringUtils.isNotEmpty((String)this.step.overrideCredentialId)) {
                Credential credential = new Credential("Overriding", "", Secret.fromString((String)""), this.step.overrideCredentialId, true, null);
                return credential;
            }
            return null;
        }
    }

    @Extension
    public static final class XLReleaseStepDescriptor
    extends AbstractStepDescriptorImpl {
        private final XLReleaseNotifier.XLReleaseDescriptor descriptor = new XLReleaseNotifier.XLReleaseDescriptor();

        public XLReleaseStepDescriptor() {
            super(XLReleaseExecution.class);
        }

        public String getFunctionName() {
            return "xlrCreateRelease";
        }

        public String getDisplayName() {
            return "Create and invoke a XLR release";
        }

        public AutoCompletionCandidates doAutoCompleteTemplate(@QueryParameter String value, @AncestorInPath AbstractProject project) {
            return this.getXLReleaseDescriptor().doAutoCompleteTemplate(value, project);
        }

        public FormValidation doValidateTemplate(@QueryParameter String serverCredentials, @QueryParameter boolean overridingCredential, @QueryParameter String template, @AncestorInPath AbstractProject project) {
            return this.getXLReleaseDescriptor().doValidateTemplate(serverCredentials, overridingCredential, template, project);
        }

        public ListBoxModel doFillServerCredentialsItems() {
            return this.getXLReleaseDescriptor().doFillCredentialItems();
        }

        public Map<String, String> getVariablesOf(String credential, String template) {
            return this.getXLReleaseDescriptor().getVariablesOf(credential, null, template);
        }

        public FormValidation doCheckServerCredentials(@QueryParameter String serverCredentials) {
            return this.getXLReleaseDescriptor().doCheckCredential(serverCredentials);
        }

        public int getNumberOfVariables(@QueryParameter String serverCredentials, @QueryParameter boolean overridingCredential, @QueryParameter String username, @QueryParameter String password, @QueryParameter boolean useGlobalCredential, @QueryParameter String credentialsId, @QueryParameter String template) {
            return this.getXLReleaseDescriptor().getNumberOfVariables(serverCredentials, overridingCredential, username, password, useGlobalCredential, credentialsId, template);
        }

        private XLReleaseNotifier.XLReleaseDescriptor getXLReleaseDescriptor() {
            this.descriptor.load();
            return this.descriptor;
        }
    }
}

