/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci.util;

import com.xebialabs.xlrelease.ci.util.Release;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true)
public class Folder {
    private String id;
    private String title;
    private List<Folder> folderList;
    private List<Release> templates;

    public Folder() {
    }

    public Folder(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFolderList(List<Folder> folderList) {
        this.folderList = folderList;
    }

    public void setTemplates(List<Release> templates) {
        this.templates = templates;
    }

    public List<Folder> getFolderList() {
        return this.folderList;
    }

    public List<Release> getTemplates() {
        return this.templates;
    }

    public List<Release> getAllTemplates() {
        ArrayList<Release> templates = new ArrayList<Release>();
        for (Release release : this.templates) {
            Release rel = new Release();
            rel.setId(release.getId());
            rel.setTitle(this.title + "/" + release.getTitle());
            templates.add(rel);
        }
        for (Folder folder : this.folderList) {
            for (Release release : folder.getAllTemplates()) {
                release.setTitle(this.title + "/" + release.getTitle());
                templates.add(release);
            }
        }
        return templates;
    }

    public String toString() {
        return "Folder{id='" + this.id + '\'' + ", title='" + this.title + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Folder that = (Folder)o;
        return !(this.title != null ? !this.title.equals(that.title) : that.title != null);
    }

    public int hashCode() {
        return this.title != null ? this.title.hashCode() : 0;
    }
}

