/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci.server;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.ci.Credential;
import com.xebialabs.xlrelease.ci.server.PluginFirstClassloaderInvocationHandler;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnector;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnectorFacade;
import hudson.util.Secret;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.logging.Logger;

public class XLReleaseServerFactory {
    private static final Logger LOGGER = Logger.getLogger(XLReleaseServerFactory.class.getName());

    public boolean validConnection(String serverUrl, String proxyUrl, String username, String password) throws IllegalStateException {
        this.newInstance(serverUrl, proxyUrl, username, password).testConnection();
        return true;
    }

    public XLReleaseServerConnector newInstance(String serverUrl, String proxyUrl, String username, String password) {
        return this.newInstance(serverUrl, proxyUrl, new Credential(username, username, Secret.fromString((String)password), null, false, null));
    }

    public XLReleaseServerConnector newInstance(String serverUrl, String proxyUrl, Credential credential) {
        String password;
        String userName = credential.getUsername();
        String string = password = credential.getPassword() != null ? credential.getPassword().getPlainText() : "";
        if (credential.isUseGlobalCredential()) {
            LOGGER.info("Performing lookup for system credentials");
            StandardUsernamePasswordCredentials cred = Credential.CredentialDescriptor.lookupSystemCredentials(credential.getCredentialsId());
            if (cred == null) {
                throw new IllegalArgumentException(String.format("Credentials for '%s' not found.", credential.getCredentialsId()));
            }
            userName = cred.getUsername();
            String string2 = password = cred.getPassword() != null ? cred.getPassword().getPlainText() : "";
        }
        if (userName == null) {
            throw new IllegalArgumentException("user name cannot be null");
        }
        XLReleaseServerConnectorFacade server = new XLReleaseServerConnectorFacade(serverUrl, proxyUrl, userName, password);
        return XLReleaseServerFactory.newProxy(XLReleaseServerConnector.class, new PluginFirstClassloaderInvocationHandler(server));
    }

    public static String getNameFromId(String id) {
        String[] nameParts = id.split("/");
        return nameParts[nameParts.length - 1];
    }

    public static String getParentId(String id) {
        Object[] nameParts = id.split("/");
        ArrayList list = Lists.newArrayList((Object[])nameParts);
        if (list.size() > 1) {
            list.remove(nameParts.length - 1);
        }
        return Joiner.on((String)"/").join((Iterable)list);
    }

    public static <T> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        XLReleaseServerFactory.checkNotNull(interfaceType);
        XLReleaseServerFactory.checkNotNull(handler);
        XLReleaseServerFactory.checkArgument(interfaceType.isInterface());
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }
}

