/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci.server;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.xlrelease.ci.NameValuePair;
import com.xebialabs.xlrelease.ci.server.XLReleaseConnectorImpl;
import com.xebialabs.xlrelease.ci.server.XLReleaseConnectorImplPre48;
import com.xebialabs.xlrelease.ci.server.XLReleaseConnectorPost6Impl;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnector;
import com.xebialabs.xlrelease.ci.util.Release;
import com.xebialabs.xlrelease.ci.util.TemplateVariable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XLReleaseServerConnectorFacade
implements XLReleaseServerConnector {
    private XLReleaseServerConnector connectorPre48;
    private XLReleaseServerConnector defaultConnector;
    private XLReleaseServerConnector connectorPost6;

    XLReleaseServerConnectorFacade(String serverUrl, String proxyUrl, String username, String password) {
        this.connectorPre48 = new XLReleaseConnectorImplPre48(serverUrl, proxyUrl, username, password);
        this.defaultConnector = new XLReleaseConnectorImpl(serverUrl, proxyUrl, username, password);
        this.connectorPost6 = new XLReleaseConnectorPost6Impl(serverUrl, proxyUrl, username, password);
    }

    private XLReleaseServerConnector getConnectorForXlrVersion() {
        String versionString = this.getVersion();
        if (this.isVersionPre48(versionString)) {
            return this.connectorPre48;
        }
        if (this.isVersionPost60(versionString)) {
            return this.connectorPost6;
        }
        return this.defaultConnector;
    }

    @Override
    public void testConnection() {
        this.getConnectorForXlrVersion().testConnection();
    }

    @Override
    public String getVersion() {
        return this.defaultConnector.getVersion();
    }

    @Override
    public List<Release> searchTemplates(String filter) {
        return this.getConnectorForXlrVersion().searchTemplates(filter);
    }

    @Override
    public List<Release> getAllTemplates() {
        return this.getConnectorForXlrVersion().getAllTemplates();
    }

    @Override
    public List<TemplateVariable> getVariables(String templateId) {
        return this.getConnectorForXlrVersion().getVariables(templateId);
    }

    @Override
    public Release createRelease(String resolvedTemplate, String resolvedVersion, List<NameValuePair> variables) {
        return this.getConnectorForXlrVersion().createRelease(resolvedTemplate, resolvedVersion, variables);
    }

    @Override
    public void startRelease(String releaseId) {
        this.getConnectorForXlrVersion().startRelease(releaseId);
    }

    @Override
    public String getServerURL() {
        return this.getConnectorForXlrVersion().getServerURL();
    }

    @VisibleForTesting
    boolean isVersionPre48(String versionString) {
        if (versionString == null) {
            return false;
        }
        if (versionString.startsWith("0.0.")) {
            return false;
        }
        Matcher matcher = Pattern.compile("^(\\d+)\\.(\\d+)\\..*").matcher(versionString);
        if (!matcher.matches()) {
            return false;
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        return major < 4 || major == 4 && minor < 8;
    }

    boolean isVersionPost60(String versionString) {
        if (versionString == null) {
            return false;
        }
        if (versionString.startsWith("0.0.")) {
            return false;
        }
        Matcher matcher = Pattern.compile("^(\\d+)\\.(\\d+)\\..*").matcher(versionString);
        if (!matcher.matches()) {
            return false;
        }
        int major = Integer.parseInt(matcher.group(1));
        return major >= 6;
    }
}

