/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci.server;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.xebialabs.xlrelease.ci.NameValuePair;
import com.xebialabs.xlrelease.ci.server.AbstractXLReleaseConnector;
import com.xebialabs.xlrelease.ci.util.CreateReleaseInternalForm;
import com.xebialabs.xlrelease.ci.util.TemplateVariable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class XLReleaseConnectorImplPre48
extends AbstractXLReleaseConnector {
    protected XLReleaseConnectorImplPre48(String serverUrl, String proxyUrl, String username, String password) {
        super(serverUrl, proxyUrl, username, password);
    }

    @Override
    public ClientResponse getVariablesResponse(String templateId) {
        WebResource service = this.buildWebResource();
        return (ClientResponse)service.path("releases").path(templateId).path("updatable-variables").accept(new String[]{"application/json"}).get(ClientResponse.class);
    }

    @Override
    public ClientResponse createReleaseResponse(String templateTitle, String releaseTitle, List<NameValuePair> variables) {
        WebResource service = this.buildWebResource();
        String templateInternalId = this.getTemplateInternalId(templateTitle);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String scheduledStartDate = format.format(Calendar.getInstance().getTime());
        Calendar dueDate = Calendar.getInstance();
        dueDate.add(5, 1);
        String scheduledDueDate = format.format(dueDate.getTime());
        CreateReleaseInternalForm createReleaseInternalForm = new CreateReleaseInternalForm(templateInternalId, releaseTitle, this.convertToVariablesList(variables), scheduledDueDate, scheduledStartDate);
        return (ClientResponse)service.path("releases").type("application/json").post(ClientResponse.class, (Object)createReleaseInternalForm);
    }

    @Override
    public ClientResponse startReleaseResponse(String releaseId) {
        WebResource service = this.buildWebResource();
        return (ClientResponse)service.path("releases").path(releaseId).path("start").type("application/json").post(ClientResponse.class);
    }

    @Override
    public List<TemplateVariable> filterVariables(List<TemplateVariable> variables) {
        CollectionUtils.filter(variables, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                if (o instanceof TemplateVariable) {
                    ArrayList<String> acceptedTypes = new ArrayList<String>();
                    acceptedTypes.add("DEFAULT");
                    acceptedTypes.add("DEPLOYIT_ENVIRONMENT");
                    acceptedTypes.add("DEPLOYIT_PACKAGE");
                    return acceptedTypes.contains(((TemplateVariable)o).getType());
                }
                return false;
            }
        });
        return variables;
    }
}

