/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci.server;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.xebialabs.xlrelease.ci.NameValuePair;
import com.xebialabs.xlrelease.ci.server.AbstractXLReleaseConnector;
import com.xebialabs.xlrelease.ci.util.CreateReleasePublicForm;
import com.xebialabs.xlrelease.ci.util.TemplateVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class XLReleaseConnectorImpl
extends AbstractXLReleaseConnector {
    public XLReleaseConnectorImpl(String serverUrl, String proxyUrl, String username, String password) {
        super(serverUrl, proxyUrl, username, password);
    }

    @Override
    public ClientResponse getVariablesResponse(String templateId) {
        WebResource service = this.buildWebResource();
        return (ClientResponse)service.path("api/v1/templates/Applications").path(templateId).path("variables").accept(new String[]{"application/json"}).get(ClientResponse.class);
    }

    @Override
    public ClientResponse createReleaseResponse(String resolvedTemplate, String resolvedVersion, List<NameValuePair> variables) {
        WebResource service = this.buildWebResource();
        String templateInternalId = this.getTemplateInternalId(resolvedTemplate);
        List<TemplateVariable> varList = this.getVariables(templateInternalId);
        HashMap<String, TemplateVariable> templateVariables = new HashMap<String, TemplateVariable>();
        for (TemplateVariable tempVar : varList) {
            templateVariables.put(tempVar.getKey(), tempVar);
        }
        CreateReleasePublicForm createReleasePublicForm = new CreateReleasePublicForm(resolvedVersion, this.convertToVariablesMap(variables, templateVariables));
        return (ClientResponse)((WebResource.Builder)service.path("api/v1/templates/Applications").path(templateInternalId).path("create").type("application/json").accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)createReleasePublicForm);
    }

    @Override
    public ClientResponse startReleaseResponse(String releaseId) {
        WebResource service = this.buildWebResource();
        return (ClientResponse)service.path("api/v1/releases/Applications").path(releaseId).path("start").accept(new String[]{"application/json"}).post(ClientResponse.class);
    }

    @Override
    public List<TemplateVariable> filterVariables(List<TemplateVariable> variables) {
        CollectionUtils.filter(variables, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                if (o instanceof TemplateVariable) {
                    ArrayList<String> acceptedTypes = new ArrayList<String>();
                    acceptedTypes.add("xlrelease.StringVariable");
                    acceptedTypes.add("xlrelease.XLDeployPackageVariable");
                    acceptedTypes.add("xlrelease.XLDeployEnvironmentVariable");
                    acceptedTypes.add("xlrelease.BooleanVariable");
                    acceptedTypes.add("xlrelease.DateVariable");
                    acceptedTypes.add("xlrelease.IntegerVariable");
                    acceptedTypes.add("xlrelease.ListStringVariable");
                    acceptedTypes.add("xlrelease.MapStringStringVariable");
                    acceptedTypes.add("xlrelease.PasswordStringVariable");
                    acceptedTypes.add("xlrelease.SetStringVariable");
                    acceptedTypes.add("xlrelease.ListOfStringValueProviderConfiguration");
                    return acceptedTypes.contains(((TemplateVariable)o).getType());
                }
                return false;
            }
        });
        return variables;
    }
}

