/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci.server;

import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.xebialabs.xlrelease.ci.NameValuePair;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnector;
import com.xebialabs.xlrelease.ci.util.ObjectMapperProvider;
import com.xebialabs.xlrelease.ci.util.Release;
import com.xebialabs.xlrelease.ci.util.ServerInfo;
import com.xebialabs.xlrelease.ci.util.TemplateVariable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXLReleaseConnector
implements XLReleaseServerConnector {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractXLReleaseConnector.class);
    private String user;
    private String password;
    private String proxyUrl;
    private String serverUrl;

    protected AbstractXLReleaseConnector(String serverUrl, String proxyUrl, String username, String password) {
        this.user = username;
        this.password = password;
        this.proxyUrl = proxyUrl;
        this.serverUrl = serverUrl;
        System.out.println("AbstractXLReleaseConnector<init>: " + serverUrl + ", " + proxyUrl + ", " + username);
    }

    @Override
    public String getVersion() {
        WebResource service = this.buildWebResource();
        ServerInfo serverInfo = (ServerInfo)service.path("server").path("info").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ServerInfo.class);
        String version = serverInfo.getVersion();
        System.out.println("XLR Version: " + version);
        return version;
    }

    @Override
    public void testConnection() {
        logger.info("Check that XL Release is running");
        WebResource service = this.buildWebResource();
        ClientResponse response = (ClientResponse)service.path("profile").accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new IllegalStateException(response.getStatusInfo().getReasonPhrase());
        }
        String xlrelease = response.toString();
        logger.info("Response: {}", (Object)xlrelease);
    }

    @Override
    public List<Release> searchTemplates(final String filter) {
        List<Release> templates = this.getAllTemplates();
        CollectionUtils.filter(templates, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return ((Release)o).getTitle().toLowerCase().startsWith(filter.toLowerCase());
            }
        });
        logger.info(templates + "\n");
        return templates;
    }

    @Override
    public List<Release> getAllTemplates() {
        logger.info("Get all the templates");
        WebResource service = this.buildWebResource();
        GenericType<List<Release>> genericType = new GenericType<List<Release>>(){};
        return (List)service.path("api").path("v1").path("templates").accept(new String[]{"application/json"}).get((GenericType)genericType);
    }

    @Override
    public List<TemplateVariable> getVariables(String templateId) {
        logger.info("Getting variables from xl-release");
        ClientResponse response = this.getVariablesResponse(templateId);
        this.failIfUnsuccessful(response);
        GenericType<List<TemplateVariable>> genericType = new GenericType<List<TemplateVariable>>(){};
        List variableList = (List)response.getEntity((GenericType)genericType);
        return this.filterVariables(variableList);
    }

    @Override
    public Release createRelease(String resolvedTemplate, String resolvedVersion, List<NameValuePair> variables) {
        logger.info("Creating Release with template {}", (Object)resolvedTemplate);
        ClientResponse response = this.createReleaseResponse(resolvedTemplate, resolvedVersion, variables);
        this.failIfUnsuccessful(response);
        GenericType<Release> genericType = new GenericType<Release>(){};
        return (Release)response.getEntity((GenericType)genericType);
    }

    @Override
    public void startRelease(String releaseId) {
        logger.info("Starting release {}", (Object)releaseId);
        ClientResponse response = this.startReleaseResponse(releaseId);
        this.failIfUnsuccessful(response);
    }

    private void failIfUnsuccessful(ClientResponse response) {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            String errorReason = (String)response.getEntity(String.class);
            throw new IllegalStateException(errorReason);
        }
    }

    protected WebResource buildWebResource() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        JacksonJaxbJsonProvider jacksonProvider = new JacksonJaxbJsonProvider();
        jacksonProvider.setMapper(new ObjectMapperProvider().getMapper());
        config.getSingletons().add(jacksonProvider);
        Client client = Client.create((ClientConfig)config);
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.user, this.password));
        return client.resource(this.serverUrl.replace("\"", ""));
    }

    protected String getTemplateInternalId(final String templateTitle) {
        List<Release> templates = this.searchTemplates(templateTitle);
        CollectionUtils.filter(templates, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return ((Release)o).getTitle().equals(templateTitle);
            }
        });
        if (templates.size() == 0) {
            throw new RuntimeException("No template found for template id : " + templateTitle);
        }
        return templates.get(0).getInternalId();
    }

    protected List<TemplateVariable> convertToVariablesList(List<NameValuePair> variables) {
        ArrayList<TemplateVariable> result = new ArrayList<TemplateVariable>();
        for (NameValuePair variable : variables) {
            result.add(new TemplateVariable(variable.propertyName, variable.propertyValue));
        }
        return result;
    }

    protected Map<String, Object> convertToVariablesMap(List<NameValuePair> variables, Map<String, TemplateVariable> templateVariables) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        for (NameValuePair variable : variables) {
            String varType = templateVariables.get(variable.getPropertyName()).getType();
            variablesMap.put(this.getVariableName(variable.getPropertyName()), this.castVariable(variable.propertyValue, varType));
        }
        return variablesMap;
    }

    private String getVariableName(String variable) {
        if (!TemplateVariable.isVariable(variable)) {
            return NameValuePair.VARIABLE_PREFIX + variable + NameValuePair.VARIABLE_SUFFIX;
        }
        return variable;
    }

    private Object castVariable(String variable, String type) {
        switch (type) {
            case "xlrelease.BooleanVariable": {
                return Boolean.valueOf(variable);
            }
            case "xlrelease.IntegerVariable": {
                return Integer.valueOf(variable);
            }
            case "xlrelease.DateVariable": {
                return this.parseDate(variable);
            }
            case "xlrelease.ListStringVariable": {
                return this.parseList(variable);
            }
            case "xlrelease.MapStringStringVariable": {
                return this.parseMap(variable);
            }
            case "xlrelease.SetStringVariable": {
                return this.parseSet(variable);
            }
        }
        return variable;
    }

    private Date parseDate(String s) {
        ArrayList<SimpleDateFormat> formats = new ArrayList<SimpleDateFormat>();
        formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX"));
        formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
        formats.add(new SimpleDateFormat("yyyy-MM-dd"));
        formats.add(new SimpleDateFormat("dd-MMM-yyyy"));
        formats.add(new SimpleDateFormat("dd/MM/yyyy"));
        for (SimpleDateFormat format : formats) {
            try {
                return new Date(format.parse(s).getTime());
            }
            catch (ParseException parseException) {
            }
        }
        throw new RuntimeException("Date '" + s + "' is invalid.\nSupported date formats:\nyyyy-MM-dd'T'HH:mm:ss.SSSZ\nyyyy-MM-dd'T'HH:mm:ssXXX\nyyyy-MM-dd'T'HH:mm:ssZ\nyyyy-MM-dd\ndd-MMM-yyyy\ndd/MM/yyyy\nEx. 2019-08-28T11:23:18Z");
    }

    private List<String> parseList(String s) {
        List<String> list = Arrays.asList(s.split(","));
        list.replaceAll(String::trim);
        return list;
    }

    private Map<String, String> parseMap(String s) {
        Gson g = new Gson();
        Map map = (Map)g.fromJson(s, Map.class);
        return map;
    }

    private Set<String> parseSet(String s) {
        List<String> list = this.parseList(s);
        Set<String> set = list.stream().collect(Collectors.toSet());
        return set;
    }

    @Override
    public String getServerURL() {
        return this.serverUrl;
    }

    protected abstract ClientResponse getVariablesResponse(String var1);

    protected abstract ClientResponse createReleaseResponse(String var1, String var2, List<NameValuePair> var3);

    protected abstract ClientResponse startReleaseResponse(String var1);

    protected abstract List<TemplateVariable> filterVariables(List<TemplateVariable> var1);
}

