/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.xebialabs.xlrelease.ci.Credential;
import com.xebialabs.xlrelease.ci.Messages;
import com.xebialabs.xlrelease.ci.NameValuePair;
import com.xebialabs.xlrelease.ci.RepositoryUtils;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnector;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnectorFactory;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerFactory;
import com.xebialabs.xlrelease.ci.util.JenkinsReleaseListener;
import com.xebialabs.xlrelease.ci.util.Release;
import com.xebialabs.xlrelease.ci.util.TemplateVariable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class XLReleaseNotifier
extends Notifier {
    public final String credential;
    public final String template;
    public final String version;
    public List<NameValuePair> variables;
    public final boolean startRelease;
    public Credential overridingCredential;

    @DataBoundConstructor
    public XLReleaseNotifier(String credential, String template, String version, List<NameValuePair> variables, boolean startRelease, Credential overridingCredential) {
        this.credential = credential;
        this.template = template;
        this.version = version;
        this.variables = variables;
        this.startRelease = startRelease;
        this.overridingCredential = overridingCredential;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String cred = this.credential;
        Credential credential = RepositoryUtils.findCredential(cred);
        if (null != credential && null != this.overridingCredential) {
            credential = RepositoryUtils.retrieveOverridingCredential(credential, this.overridingCredential.getCredentialsId(), credential.getName(), this.overridingCredential.getUsername(), this.overridingCredential.getPassword(), this.overridingCredential.isUseGlobalCredential());
        }
        XLReleaseDescriptor descriptor = RepositoryUtils.getXLreleaseDescriptor();
        XLReleaseServerConnector xlReleaseServerConnector = descriptor.getXLReleaseServer(credential, (Job<?, ?>)build.getProject());
        return this.executeRelease(build.getEnvironment((TaskListener)listener), (TaskListener)listener, xlReleaseServerConnector);
    }

    public boolean executeRelease(EnvVars envVars, TaskListener listener, XLReleaseServerConnector xlReleaseServerConnector) {
        JenkinsReleaseListener deploymentListener = new JenkinsReleaseListener(listener);
        String resolvedVersion = envVars.expand(this.version);
        ArrayList<NameValuePair> resolvedVariables = new ArrayList<NameValuePair>();
        if (CollectionUtils.isNotEmpty(this.variables)) {
            for (NameValuePair nameValuePair : this.variables) {
                resolvedVariables.add(new NameValuePair(nameValuePair.propertyName, envVars.expand(nameValuePair.propertyValue)));
            }
        }
        Release release = this.createRelease(this.template, resolvedVersion, resolvedVariables, xlReleaseServerConnector);
        deploymentListener.info(Messages.XLReleaseNotifier_createRelease(this.template, resolvedVersion, release.getId()));
        if (this.startRelease) {
            deploymentListener.info(Messages.XLReleaseNotifier_startRelease(this.template, resolvedVersion, release.getId()));
            this.startRelease(release, xlReleaseServerConnector);
        }
        String releaseUrl = xlReleaseServerConnector.getServerURL() + release.getReleaseURL();
        deploymentListener.info(Messages.XLReleaseNotifier_releaseLink(releaseUrl));
        return true;
    }

    private Release createRelease(String resolvedTemplate, String resolvedVersion, List<NameValuePair> resolvedVariables, XLReleaseServerConnector xlReleaseServerConnector) {
        Release release = xlReleaseServerConnector.createRelease(resolvedTemplate, resolvedVersion, resolvedVariables);
        return release;
    }

    private void startRelease(Release release, XLReleaseServerConnector xlReleaseServerConnector) {
        xlReleaseServerConnector.startRelease(release.getInternalId());
    }

    public XLReleaseDescriptor getDescriptor() {
        XLReleaseDescriptor descriptor = (XLReleaseDescriptor)super.getDescriptor();
        descriptor.load();
        return descriptor;
    }

    public boolean showGolbalCredentials() {
        return this.overridingCredential.isUseGlobalCredential();
    }

    public Credential getOverridingCredential() {
        return this.overridingCredential;
    }

    @Extension
    public static final class XLReleaseDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String xlReleaseServerUrl;
        private String xlReleaseClientProxyUrl;
        private List<Credential> credentials = Lists.newArrayList();
        private static final SchemeRequirement HTTP_SCHEME = new SchemeRequirement("http");
        private static final SchemeRequirement HTTPS_SCHEME = new SchemeRequirement("https");
        private final XLReleaseServerConnectorFactory connectorHolder = new XLReleaseServerConnectorFactory();
        private final transient Map<String, XLReleaseServerConnector> xlrCredentialServerMap = Maps.newHashMap();
        private final transient Map<String, SoftReference<XLReleaseServerConnector>> credentialServerMap = new HashMap<String, SoftReference<XLReleaseServerConnector>>();
        private static transient XLReleaseServerFactory xlReleaseServerFactory = new XLReleaseServerFactory();
        public transient String lastCredential;
        public transient Credential lastOverridingCredential;
        private Release release;

        public XLReleaseDescriptor() {
            this.load();
        }

        private XLReleaseServerConnector newXLreleaseServer(Credential credential, ItemGroup<?> itemGroup) {
            String serverUrl = credential.resolveServerUrl(this.xlReleaseServerUrl);
            String proxyUrl = credential.resolveProxyUrl(this.xlReleaseClientProxyUrl);
            String userName = credential.getUsername();
            String password = credential.getPassword().getPlainText();
            if (credential.isUseGlobalCredential()) {
                StandardUsernamePasswordCredentials cred = Credential.lookupSystemCredentials(credential.getCredentialsId(), itemGroup);
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Credentials for '%s' not found.", credential.getCredentialsId()));
                }
                userName = cred.getUsername();
                password = cred.getPassword().getPlainText();
            }
            return xlReleaseServerFactory.newInstance(serverUrl, proxyUrl, userName, password);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XLReleaseServerConnector getXLReleaseServer(Credential credential, Job<?, ?> project) {
            XLReleaseServerConnector xlReleaseServerConnector = null;
            if (null != credential) {
                SoftReference<XLReleaseServerConnector> xlreleaseServerRef = this.credentialServerMap.get(credential.getKey());
                if (null != xlreleaseServerRef) {
                    xlReleaseServerConnector = xlreleaseServerRef.get();
                }
                if (null == xlReleaseServerConnector) {
                    XLReleaseDescriptor xLReleaseDescriptor = this;
                    synchronized (xLReleaseDescriptor) {
                        xlReleaseServerConnector = this.newXLreleaseServer(credential, project.getParent());
                        this.credentialServerMap.put(credential.getKey(), new SoftReference<XLReleaseServerConnector>(xlReleaseServerConnector));
                    }
                }
            }
            return xlReleaseServerConnector;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.xlReleaseServerUrl = json.get("xlReleaseServerUrl").toString();
            this.xlReleaseClientProxyUrl = json.get("xlReleaseClientProxyUrl").toString();
            this.credentials = req.bindJSONToList(Credential.class, json.get("credentials"));
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.XLReleaseNotifier_displayName();
        }

        private FormValidation validateOptionalUrl(String url) {
            try {
                if (!Strings.isNullOrEmpty((String)url)) {
                    new URL(url);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"%s is not a valid URL.", (Object[])new Object[]{url});
            }
            return FormValidation.ok();
        }

        public synchronized void load() {
            super.load();
            this.connectorHolder.load(this.xlReleaseServerUrl, this.xlReleaseClientProxyUrl);
        }

        public FormValidation doCheckXLReleaseServerUrl(@QueryParameter String xlReleaseServerUrl) {
            if (Strings.isNullOrEmpty((String)xlReleaseServerUrl)) {
                return FormValidation.error((String)"Url required.");
            }
            return this.validateOptionalUrl(xlReleaseServerUrl);
        }

        public FormValidation doCheckXLReleaseClientProxyUrl(@QueryParameter String xlReleaseClientProxyUrl) {
            return this.validateOptionalUrl(xlReleaseClientProxyUrl);
        }

        public FormValidation doValidateTemplate(@QueryParameter String credential, @QueryParameter boolean overridingCredential, @QueryParameter String template, @AncestorInPath AbstractProject project) {
            try {
                Credential overridingCredentialTemp = null;
                if (overridingCredential) {
                    overridingCredentialTemp = RepositoryUtils.retrieveOverridingCredentialFromProject(project);
                }
                XLReleaseServerConnector xlreleaseServer = RepositoryUtils.getXLreleaseServer(credential, overridingCredentialTemp, project);
                this.release = this.getTemplate(xlreleaseServer, template);
                if (this.release != null && !"folder".equals(this.release.getStatus())) {
                    return FormValidation.ok((String)"%s is valid template.", (Object[])new Object[]{template});
                }
                return FormValidation.error((String)"Template does not exist.");
            }
            catch (UniformInterfaceException exp) {
                return FormValidation.error((String)"Template does not exist.");
            }
            catch (Exception exp) {
                exp.printStackTrace();
                return FormValidation.warning((String)("Failed to communicate with XL Release server: " + exp.getMessage()));
            }
        }

        private Release getTemplate(XLReleaseServerConnector xlreleaseServer, String value) {
            List<Release> candidates = xlreleaseServer.searchTemplates(value);
            for (Release candidate : candidates) {
                if (!candidate.getTitle().equals(value)) continue;
                candidate.setVariableValues(this.getVariables(xlreleaseServer, candidate));
                return candidate;
            }
            return null;
        }

        private Map<String, String> getVariables(XLReleaseServerConnector xlreleaseServer, Release release) {
            List<TemplateVariable> variables = xlreleaseServer.getVariables(release.getInternalId());
            return TemplateVariable.toMap(variables);
        }

        public AutoCompletionCandidates doAutoCompleteTemplate(@QueryParameter String value, @AncestorInPath AbstractProject project) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            XLReleaseNotifier xlReleaseNotifier = RepositoryUtils.retrieveXLreleaseNotifierFromProject(project);
            if (xlReleaseNotifier != null) {
                Credential overridingcredential = RepositoryUtils.retrieveOverridingCredentialFromProject(project);
                XLReleaseServerConnector xlReleaseServerConnector = RepositoryUtils.getXLreleaseServer(xlReleaseNotifier.credential, overridingcredential, project);
                List<Release> releases = xlReleaseServerConnector.searchTemplates(value);
                for (Release release : releases) {
                    candidates.add(release.getTitle());
                }
            }
            return candidates;
        }

        public FormValidation doReloadTemplates(@QueryParameter String credential, @QueryParameter boolean overridingCredential, @AncestorInPath AbstractProject project) {
            if (overridingCredential) {
                XLReleaseNotifier notifier = (XLReleaseNotifier)project.getPublishersList().get((Descriptor)this);
                this.lastOverridingCredential = notifier.overridingCredential;
            } else {
                this.lastOverridingCredential = null;
            }
            this.lastCredential = credential;
            return FormValidation.ok();
        }

        public List<Credential> getCredentials() {
            return this.credentials;
        }

        public void setCredentials(List<Credential> credentials) {
            this.credentials = credentials;
        }

        public String getXlReleaseServerUrl() {
            return this.xlReleaseServerUrl;
        }

        public void setXlReleaseServerUrl(String url) {
            this.xlReleaseServerUrl = url;
        }

        public String getXlReleaseClientProxyUrl() {
            return this.xlReleaseClientProxyUrl;
        }

        public void setXlReleaseClientProxyUrl(String url) {
            this.xlReleaseClientProxyUrl = url;
        }

        public ListBoxModel doFillCredentialItems() {
            ListBoxModel m = new ListBoxModel();
            m.add("-- Please Select --", "");
            for (Credential c : this.credentials) {
                m.add(c.name, c.name);
            }
            return m;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{HTTP_SCHEME, HTTPS_SCHEME});
            return new StandardUsernameListBoxModel().withAll((Iterable)creds);
        }

        public FormValidation doCheckCredential(@QueryParameter String credential) {
            this.lastCredential = credential;
            if (StringUtils.isEmpty((String)credential)) {
                return FormValidation.error((String)"Please select a valid credential");
            }
            return FormValidation.warning((String)"Changing credentials may unintentionally change your available templates");
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }

        private XLReleaseServerConnector getXLReleaseServer(String credentialName, Credential overridingCredential) {
            return this.connectorHolder.getXLReleaseServerConnector(this.getCombinedCredential(credentialName, overridingCredential), this.xlrCredentialServerMap);
        }

        public Credential getCombinedCredential(String credentialName, Credential overridingCredential) {
            Preconditions.checkNotNull((Object)credentialName);
            Credential credential = this.findCredential(credentialName);
            if (credential == null) {
                throw new IllegalArgumentException("credential '" + credentialName + "' not found");
            }
            if (null != overridingCredential && overridingCredential.getUsername() != null) {
                credential = new Credential(credential.getName(), overridingCredential.getUsername(), overridingCredential.getPassword(), overridingCredential.getCredentialsId(), overridingCredential.isUseGlobalCredential(), overridingCredential.getSecondaryServerInfo());
            }
            return credential;
        }

        public Credential findCredential(String credentialName) {
            for (Credential credential : this.credentials) {
                if (!credentialName.equals(credential.getName())) continue;
                return credential;
            }
            throw new IllegalArgumentException(Messages.XLReleaseNotifier_credentialNotFound(credentialName));
        }

        public Map<String, String> getVariablesOf(String credential, Credential overridingCredential, String template) {
            try {
                XLReleaseServerConnector xlreleaseServer = this.getXLReleaseServer(credential, overridingCredential);
                this.release = this.getTemplate(xlreleaseServer, template);
                if (this.release != null) {
                    return this.release.getVariableValues();
                }
            }
            catch (UniformInterfaceException ex) {
                HashMap<String, String> errmsg = new HashMap<String, String>();
                errmsg.put("ERROR: " + ex.getMessage(), "");
                return errmsg;
            }
            return Collections.emptyMap();
        }

        public int getNumberOfVariables(@QueryParameter String credential, @QueryParameter boolean overridingCredential, @QueryParameter String username, @QueryParameter String password, @QueryParameter boolean useGlobalCredential, @QueryParameter String credentialsId, @QueryParameter String template) {
            if (credential != null) {
                Map<String, String> variables;
                Credential overridingCredentialTemp = null;
                if (overridingCredential) {
                    overridingCredentialTemp = new Credential(credential, username, Secret.fromString((String)password), credentialsId, useGlobalCredential, null);
                }
                if ((variables = this.getVariablesOf(credential, overridingCredentialTemp, template)) != null) {
                    return variables.size();
                }
            }
            return 0;
        }

        @VisibleForTesting
        public static void setXlReleaseServerFactory(XLReleaseServerFactory xlReleaseServerFactory) {
            XLReleaseDescriptor.xlReleaseServerFactory = xlReleaseServerFactory;
        }
    }
}

