/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.xebialabs.xlrelease.ci.Credential;
import com.xebialabs.xlrelease.ci.Messages;
import com.xebialabs.xlrelease.ci.XLReleaseNotifier;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnector;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.util.Secret;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RepositoryUtils {
    public static XLReleaseServerConnector getXLreleaseServer(String credentialName, Credential overridingCredential, Job<?, ?> project) {
        Credential credential = RepositoryUtils.findCredential(credentialName);
        if (null != credential && null != overridingCredential) {
            credential = RepositoryUtils.retrieveOverridingCredential(credential, overridingCredential.getCredentialsId(), credential.getName(), overridingCredential.getUsername(), overridingCredential.getPassword(), overridingCredential.isUseGlobalCredential());
        }
        XLReleaseNotifier.XLReleaseDescriptor descriptor = RepositoryUtils.getXLreleaseDescriptor();
        return descriptor.getXLReleaseServer(credential, project);
    }

    public static Credential retrieveOverridingCredential(Credential credential, String credentialId, String name, String username, Secret password, boolean useGlobalCredential) {
        XLReleaseNotifier.XLReleaseDescriptor descriptor = RepositoryUtils.getXLreleaseDescriptor();
        String secondaryProxyUrl = credential.resolveProxyUrl(descriptor.getXlReleaseClientProxyUrl());
        String secondaryServerUrl = credential.resolveServerUrl(descriptor.getXlReleaseServerUrl());
        Credential.SecondaryServerInfo serverInfo = new Credential.SecondaryServerInfo(secondaryServerUrl, secondaryProxyUrl);
        credential = new Credential(name, username, password, credentialId, useGlobalCredential, serverInfo);
        return credential;
    }

    public static XLReleaseServerConnector getXLreleaseServerFromCredentialsId(String serverCredentialName, String credentialId, Job<?, ?> project) {
        Credential credential = RepositoryUtils.findCredential(serverCredentialName);
        if (null != credential && null != credentialId) {
            StandardUsernamePasswordCredentials cred = Credential.lookupSystemCredentials(credentialId, project.getParent());
            if (null == cred) {
                throw new IllegalArgumentException(Messages.XLReleaseNotifier_credentialNotFound(credentialId));
            }
            credential = RepositoryUtils.retrieveOverridingCredential(credential, credentialId, credential.getName(), cred.getUsername(), cred.getPassword(), true);
        }
        XLReleaseNotifier.XLReleaseDescriptor descriptor = RepositoryUtils.getXLreleaseDescriptor();
        return descriptor.getXLReleaseServer(credential, project);
    }

    private static List<Credential> getGlobalCredentials() {
        return RepositoryUtils.getXLreleaseDescriptor().getCredentials();
    }

    public static Credential findCredential(String credentialName) {
        for (Credential credential : RepositoryUtils.getGlobalCredentials()) {
            if (!credentialName.equals(credential.getName())) continue;
            return credential;
        }
        throw new IllegalArgumentException(Messages.XLReleaseNotifier_credentialNotFound(credentialName));
    }

    public static Credential retrieveOverridingCredentialFromProject(AbstractProject<?, ?> project) {
        Credential overridingCredential = null;
        XLReleaseNotifier notifier = RepositoryUtils.retrieveXLreleaseNotifierFromProject(project);
        if (null != notifier && null != (overridingCredential = notifier.getOverridingCredential()) && StringUtils.isEmpty((String)overridingCredential.getUsername()) && null != overridingCredential.getCredentialsId()) {
            XLReleaseNotifier.XLReleaseDescriptor descriptor = notifier.getDescriptor();
            String secondaryProxyUrl = overridingCredential.resolveProxyUrl(descriptor.getXlReleaseClientProxyUrl());
            String secondaryServerUrl = overridingCredential.resolveServerUrl(descriptor.getXlReleaseServerUrl());
            Credential.SecondaryServerInfo serverInfo = new Credential.SecondaryServerInfo(secondaryServerUrl, secondaryProxyUrl);
            StandardUsernamePasswordCredentials cred = Credential.lookupSystemCredentials(overridingCredential.getCredentialsId(), project.getParent());
            if (null != cred) {
                overridingCredential = new Credential(overridingCredential.getName(), cred.getUsername(), cred.getPassword(), overridingCredential.getCredentialsId(), false, serverInfo);
            }
        }
        return overridingCredential;
    }

    public static XLReleaseNotifier retrieveXLreleaseNotifierFromProject(AbstractProject<?, ?> project) {
        XLReleaseNotifier notifier = null;
        XLReleaseNotifier.XLReleaseDescriptor descriptor = RepositoryUtils.getXLreleaseDescriptor();
        if (null != project) {
            notifier = (XLReleaseNotifier)project.getPublishersList().get((Descriptor)descriptor);
        }
        return notifier;
    }

    public static XLReleaseNotifier.XLReleaseDescriptor getXLreleaseDescriptor() {
        return (XLReleaseNotifier.XLReleaseDescriptor)Hudson.getInstance().getDescriptor(XLReleaseNotifier.class);
    }
}

