/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ci;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerConnector;
import com.xebialabs.xlrelease.ci.server.XLReleaseServerFactory;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Project;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Credential
extends AbstractDescribableImpl<Credential> {
    private static final SchemeRequirement HTTP_SCHEME = new SchemeRequirement("http");
    private static final SchemeRequirement HTTPS_SCHEME = new SchemeRequirement("https");
    private static final Logger LOGGER = Logger.getLogger(Credential.class.getName());
    public static final Function<Credential, String> CREDENTIAL_INDEX = new Function<Credential, String>(){

        public String apply(Credential input) {
            return input.getName();
        }
    };
    public final String name;
    public final String username;
    public final Secret password;
    public final String credentialsId;
    private final SecondaryServerInfo secondaryServerInfo;
    public final boolean useGlobalCredential;

    @DataBoundConstructor
    public Credential(String name, String username, Secret password, String credentialsId, boolean useGlobalCredential, SecondaryServerInfo secondaryServerInfo) {
        this.name = name;
        this.username = username;
        this.password = password;
        this.secondaryServerInfo = secondaryServerInfo;
        this.credentialsId = credentialsId;
        this.useGlobalCredential = useGlobalCredential;
    }

    public String getKey() {
        return this.username + ":" + this.password.getPlainText() + "@" + this.name + ":" + this.credentialsId + ":";
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public SecondaryServerInfo getSecondaryServerInfo() {
        return this.secondaryServerInfo;
    }

    public String getSecondaryServerUrl() {
        if (this.secondaryServerInfo != null) {
            return this.secondaryServerInfo.secondaryServerUrl;
        }
        return null;
    }

    public String getSecondaryProxyUrl() {
        if (this.secondaryServerInfo != null) {
            return this.secondaryServerInfo.secondaryProxyUrl;
        }
        return null;
    }

    public String resolveServerUrl(String defaultUrl) {
        if (this.secondaryServerInfo != null) {
            return this.secondaryServerInfo.resolveServerUrl(defaultUrl);
        }
        return defaultUrl;
    }

    public String resolveProxyUrl(String defaultUrl) {
        if (this.secondaryServerInfo != null) {
            return this.secondaryServerInfo.resolveProxyUrl(defaultUrl);
        }
        return defaultUrl;
    }

    public boolean showSecondaryServerSettings() {
        return this.secondaryServerInfo != null && this.secondaryServerInfo.showSecondaryServerSettings();
    }

    public boolean showGolbalCredentials() {
        return this.useGlobalCredential;
    }

    public boolean isUseGlobalCredential() {
        return this.useGlobalCredential;
    }

    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Project context) {
        List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{HTTP_SCHEME, HTTPS_SCHEME});
        return new StandardUsernameListBoxModel().withAll((Iterable)creds);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Credential that = (Credential)((Object)o);
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.password.equals((Object)that.password)) {
            return false;
        }
        if (this.secondaryServerInfo == null && that.secondaryServerInfo != null) {
            return false;
        }
        if (this.secondaryServerInfo != null && !this.secondaryServerInfo.equals(that.secondaryServerInfo)) {
            return false;
        }
        if (this.useGlobalCredential && that.useGlobalCredential && !this.credentialsId.equals(that.credentialsId)) {
            return false;
        }
        return this.username.equals(that.username);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.useGlobalCredential && this.credentialsId != null ? this.credentialsId.hashCode() : 0);
        result = 31 * result + (this.secondaryServerInfo != null ? this.secondaryServerInfo.hashCode() : 0);
        return result;
    }

    public static StandardUsernamePasswordCredentials lookupSystemCredentials(String credentialsId, ItemGroup<?> item) {
        StandardUsernamePasswordCredentials result = null;
        List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, item, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{HTTP_SCHEME, HTTPS_SCHEME});
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("[XLR] lookup credentials for '%s' in context '%s'. Found '%s'", credentialsId, item.getFullName(), creds.isEmpty() ? "nothing" : Integer.toString(creds.size()) + " items"));
            for (StandardUsernamePasswordCredentials cred : creds) {
                LOGGER.fine(String.format("[XLR]  >> id:%s, name:%s", cred.getId(), cred.getUsername()));
            }
            LOGGER.fine("[XLR] ------------------ end creds list");
        }
        if (creds.size() > 0) {
            result = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)creds, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            LOGGER.fine(String.format("[XLR] using credentails '%s'", result.getId()));
        }
        return result;
    }

    @Extension
    public static final class CredentialDescriptor
    extends Descriptor<Credential> {
        public String getDisplayName() {
            return "Credential";
        }

        private FormValidation validateOptionalUrl(String url) {
            try {
                if (!Strings.isNullOrEmpty((String)url)) {
                    new URL(url);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"%s is not a valid URL.", (Object[])new Object[]{url});
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSecondaryServerUrl(@QueryParameter String secondaryServerUrl) {
            return this.validateOptionalUrl(secondaryServerUrl);
        }

        public FormValidation doCheckSecondaryProxyUrl(@QueryParameter String secondaryProxyUrl) {
            return this.validateOptionalUrl(secondaryProxyUrl);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Project context) {
            List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{HTTP_SCHEME, HTTPS_SCHEME});
            return new StandardUsernameListBoxModel().withAll((Iterable)creds);
        }

        public FormValidation doValidateUserNamePassword(@QueryParameter String xlReleaseServerUrl, @QueryParameter String xlReleaseClientProxyUrl, @QueryParameter String username, @QueryParameter Secret password, @QueryParameter String secondaryServerUrl, @QueryParameter String secondaryProxyUrl) throws IOException {
            try {
                String proxyUrl;
                String serverUrl = Strings.isNullOrEmpty((String)secondaryServerUrl) ? xlReleaseServerUrl : secondaryServerUrl;
                String string = proxyUrl = Strings.isNullOrEmpty((String)secondaryProxyUrl) ? xlReleaseClientProxyUrl : secondaryProxyUrl;
                if (Strings.isNullOrEmpty((String)serverUrl)) {
                    return FormValidation.error((String)"No server URL specified");
                }
                XLReleaseServerConnector xlReleaseServerConnector = this.validateConnection(serverUrl, proxyUrl, username, password.getPlainText());
                return FormValidation.ok((String)"Your XL Release instance [%s] version %s is alive, and your credentials are valid!", (Object[])new Object[]{serverUrl, xlReleaseServerConnector.getVersion()});
            }
            catch (IllegalStateException e) {
                return FormValidation.error((String)e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                return FormValidation.error((String)"XL Release configuration is not valid! %s", (Object[])new Object[]{e.getMessage()});
            }
        }

        public FormValidation doValidateCredential(@QueryParameter String xlReleaseServerUrl, @QueryParameter String xlReleaseClientProxyUrl, @QueryParameter String secondaryServerUrl, @QueryParameter String secondaryProxyUrl, @QueryParameter String credentialsId) throws IOException {
            try {
                String proxyUrl;
                String serverUrl = Strings.isNullOrEmpty((String)secondaryServerUrl) ? xlReleaseServerUrl : secondaryServerUrl;
                String string = proxyUrl = Strings.isNullOrEmpty((String)secondaryProxyUrl) ? xlReleaseClientProxyUrl : secondaryProxyUrl;
                if (Strings.isNullOrEmpty((String)credentialsId)) {
                    return FormValidation.error((String)"No credentials specified");
                }
                StandardUsernamePasswordCredentials credentials = CredentialDescriptor.lookupSystemCredentials(credentialsId);
                if (credentials == null) {
                    return FormValidation.error((String)String.format("Could not find credential with id '%s'", credentialsId));
                }
                if (Strings.isNullOrEmpty((String)serverUrl)) {
                    return FormValidation.error((String)"No server URL specified");
                }
                XLReleaseServerConnector xlReleaseServerConnector = this.validateConnection(serverUrl, proxyUrl, credentials.getUsername(), credentials.getPassword().getPlainText());
                return FormValidation.ok((String)"Your XL Release instance [%s] version %s is alive, and your credentials are valid!", (Object[])new Object[]{serverUrl, xlReleaseServerConnector.getVersion()});
            }
            catch (IllegalStateException e) {
                return FormValidation.error((String)e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                return FormValidation.error((String)"XL Release configuration is not valid! %s", (Object[])new Object[]{e.getMessage()});
            }
        }

        public static StandardUsernamePasswordCredentials lookupSystemCredentials(String credentialsId) {
            if (credentialsId == null) {
                return null;
            }
            return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{HTTP_SCHEME, HTTPS_SCHEME}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        }

        private XLReleaseServerConnector validateConnection(String serverUrl, String proxyUrl, String username, String password) throws Exception {
            XLReleaseServerFactory factory = new XLReleaseServerFactory();
            XLReleaseServerConnector xlReleaseServerConnector = factory.newInstance(serverUrl, proxyUrl, username, password);
            xlReleaseServerConnector.testConnection();
            return xlReleaseServerConnector;
        }
    }

    public static class SecondaryServerInfo {
        public final String secondaryServerUrl;
        public final String secondaryProxyUrl;

        @DataBoundConstructor
        public SecondaryServerInfo(String secondaryServerUrl, String secondaryProxyUrl) {
            this.secondaryServerUrl = secondaryServerUrl;
            this.secondaryProxyUrl = secondaryProxyUrl;
        }

        public boolean showSecondaryServerSettings() {
            return !Strings.isNullOrEmpty((String)this.secondaryServerUrl) || !Strings.isNullOrEmpty((String)this.secondaryProxyUrl);
        }

        public String resolveServerUrl(String defaultUrl) {
            if (!Strings.isNullOrEmpty((String)this.secondaryServerUrl)) {
                return this.secondaryServerUrl;
            }
            return defaultUrl;
        }

        public String resolveProxyUrl(String defaultUrl) {
            if (!Strings.isNullOrEmpty((String)this.secondaryProxyUrl)) {
                return this.secondaryProxyUrl;
            }
            return defaultUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecondaryServerInfo that = (SecondaryServerInfo)o;
            if (this.secondaryProxyUrl == null && that.secondaryProxyUrl != null) {
                return false;
            }
            if (this.secondaryProxyUrl != null && !this.secondaryProxyUrl.equals(that.secondaryProxyUrl)) {
                return false;
            }
            if (this.secondaryServerUrl == null && that.secondaryServerUrl != null) {
                return false;
            }
            return this.secondaryServerUrl == null || this.secondaryServerUrl.equals(that.secondaryServerUrl);
        }

        public int hashCode() {
            int result = this.secondaryServerUrl != null ? this.secondaryServerUrl.hashCode() : 0;
            result = 31 * result + (this.secondaryProxyUrl != null ? this.secondaryProxyUrl.hashCode() : 0);
            return result;
        }
    }
}

