/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.htmlunit.WebClient;
import org.htmlunit.WebConnection;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.WebConnectionWrapper;

public abstract class FalsifyingWebConnection
extends WebConnectionWrapper {
    public FalsifyingWebConnection(WebConnection webConnection) throws IllegalArgumentException {
        super(webConnection);
    }

    public FalsifyingWebConnection(WebClient webClient) throws IllegalArgumentException {
        super(webClient);
    }

    protected WebResponse deliverFromAlternateUrl(WebRequest webRequest, URL url) throws IOException {
        URL originalUrl = webRequest.getUrl();
        webRequest.setUrl(url);
        WebResponse resp = super.getResponse(webRequest);
        resp.getWebRequest().setUrl(originalUrl);
        return resp;
    }

    protected WebResponse replaceContent(WebResponse wr, String newContent) throws IOException {
        byte[] body = newContent.getBytes(wr.getContentCharset());
        WebResponseData wrd = new WebResponseData(body, wr.getStatusCode(), wr.getStatusMessage(), wr.getResponseHeaders());
        return new WebResponse(wrd, wr.getWebRequest().getUrl(), wr.getWebRequest().getHttpMethod(), wr.getLoadTime());
    }

    protected WebResponse createWebResponse(WebRequest wr, String content, String contentType) throws IOException {
        return this.createWebResponse(wr, content, contentType, 200, "OK");
    }

    protected WebResponse createWebResponse(WebRequest wr, String content, String contentType, int responseCode, String responseMessage) throws IOException {
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        headers.add(new NameValuePair("content-type", contentType + "; charset=" + String.valueOf(StandardCharsets.UTF_8)));
        byte[] body = content.getBytes(StandardCharsets.UTF_8);
        WebResponseData wrd = new WebResponseData(body, responseCode, responseMessage, headers);
        return new WebResponse(wrd, wr.getUrl(), wr.getHttpMethod(), 0L);
    }
}

