/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.platform.font;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.platform.font.FontUtil;

public class AwtFontUtil
implements FontUtil {
    @Override
    public int countLines(String content, int pixelWidth, String fontSize) {
        String[] lines = StringUtils.split((String)content, (char)'\n');
        int lineCount = 0;
        int fontSizeInt = Integer.parseInt(fontSize.substring(0, fontSize.length() - 2));
        FontRenderContext fontRenderCtx = new FontRenderContext(null, false, true);
        for (String line : lines) {
            if (StringUtils.isBlank((CharSequence)line)) {
                ++lineCount;
                continue;
            }
            AttributedString attributedString = new AttributedString(line);
            attributedString.addAttribute(TextAttribute.SIZE, (double)fontSizeInt / 1.1);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderCtx);
            lineBreakMeasurer.nextLayout(pixelWidth);
            ++lineCount;
            while (lineBreakMeasurer.getPosition() < line.length() && lineCount < 1000) {
                lineBreakMeasurer.nextLayout(pixelWidth);
                ++lineCount;
            }
        }
        return lineCount;
    }
}

