/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.polyfill;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.Scriptable;

public class Polyfill {
    private static final Map<String, Polyfill> CACHE = new HashMap<String, Polyfill>();
    private String url_;
    private String source_;
    private Script script_;

    public static Polyfill getFetchPolyfill() throws IOException {
        return Polyfill.getPolyfill("fetch/fetch.umd.js");
    }

    private static Polyfill getPolyfill(String resouceName) throws IOException {
        Polyfill poly = CACHE.get(resouceName);
        if (poly != null) {
            return poly;
        }
        poly = new Polyfill();
        poly.source_ = IOUtils.toString((InputStream)poly.getClass().getResourceAsStream(resouceName), (Charset)StandardCharsets.UTF_8);
        poly.url_ = poly.getClass().getResource(resouceName).toExternalForm();
        CACHE.put(resouceName, poly);
        return poly;
    }

    public void apply(Context context, Scriptable scriptable) {
        if (this.script_ == null) {
            this.script_ = context.compileString(this.source_, this.url_, 0, null);
        }
        if (this.script_ != null) {
            this.script_.exec(context, scriptable);
        }
    }
}

