/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.svg;

import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Window;

@JsxClass
public class SVGMatrix
extends HtmlUnitScriptable {
    private double shearX_ = 0.0;
    private double shearY_ = 0.0;
    private double scaleX_ = 1.0;
    private double scaleY_ = 1.0;
    private double translateX_ = 0.0;
    private double translateY_ = 0.0;

    public SVGMatrix() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public SVGMatrix(Window scope) {
        this();
        this.setParentScope((Scriptable)scope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxGetter
    public double getA() {
        return this.scaleX_;
    }

    @JsxGetter
    public double getB() {
        return this.shearY_;
    }

    @JsxGetter
    public double getC() {
        return this.shearX_;
    }

    @JsxGetter
    public double getD() {
        return this.scaleY_;
    }

    @JsxGetter
    public double getE() {
        return this.translateX_;
    }

    @JsxGetter
    public double getF() {
        return this.translateY_;
    }

    @JsxSetter
    public void setA(double newValue) {
        this.scaleX_ = newValue;
    }

    @JsxSetter
    public void setB(double newValue) {
        this.shearY_ = newValue;
    }

    @JsxSetter
    public void setC(double newValue) {
        this.shearX_ = newValue;
    }

    @JsxSetter
    public void setD(double newValue) {
        this.scaleY_ = newValue;
    }

    @JsxSetter
    public void setE(double newValue) {
        this.translateX_ = newValue;
    }

    @JsxSetter
    public void setF(double newValue) {
        this.translateY_ = newValue;
    }

    @JsxFunction
    public SVGMatrix flipX() {
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = this.shearX_;
        result.shearY_ = -this.shearY_;
        result.scaleX_ = -this.scaleX_;
        result.scaleY_ = this.scaleY_;
        result.translateX_ = this.translateX_;
        result.translateY_ = this.translateY_;
        return result;
    }

    @JsxFunction
    public SVGMatrix flipY() {
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = -this.shearX_;
        result.shearY_ = this.shearY_;
        result.scaleX_ = this.scaleX_;
        result.scaleY_ = -this.scaleY_;
        result.translateX_ = this.translateX_;
        result.translateY_ = this.translateY_;
        return result;
    }

    @JsxFunction
    public SVGMatrix inverse() {
        double determinant = this.scaleX_ * this.scaleY_ - this.shearX_ * this.shearY_;
        if (Math.abs(determinant) < 1.0E-10) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Failed to execute 'inverse' on 'SVGMatrix': The matrix is not invertible.", 11);
        }
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = -this.shearX_ / determinant;
        result.shearY_ = -this.shearY_ / determinant;
        result.scaleX_ = this.scaleY_ / determinant;
        result.scaleY_ = this.scaleX_ / determinant;
        result.translateX_ = (this.shearX_ * this.translateY_ - this.scaleY_ * this.translateX_) / determinant;
        result.translateY_ = (this.shearY_ * this.translateX_ - this.scaleX_ * this.translateY_) / determinant;
        return result;
    }

    @JsxFunction
    public SVGMatrix multiply(SVGMatrix by) {
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = by.shearX_ * this.scaleX_ + by.scaleY_ * this.shearX_;
        result.shearY_ = by.scaleX_ * this.shearY_ + by.shearY_ * this.scaleY_;
        result.scaleX_ = by.scaleX_ * this.scaleX_ + by.shearY_ * this.shearX_;
        result.scaleY_ = by.shearX_ * this.shearY_ + by.scaleY_ * this.scaleY_;
        result.translateX_ = by.translateX_ * this.scaleX_ + by.translateY_ * this.shearX_ + this.translateX_;
        result.translateY_ = by.translateX_ * this.shearY_ + by.translateY_ * this.scaleY_ + this.translateY_;
        return result;
    }

    @JsxFunction
    public SVGMatrix rotate(double angle) {
        double theta = Math.toRadians(angle);
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = -sin * this.scaleX_ + cos * this.shearX_;
        result.shearY_ = cos * this.shearY_ + sin * this.scaleY_;
        result.scaleX_ = cos * this.scaleX_ + sin * this.shearX_;
        result.scaleY_ = -sin * this.shearY_ + cos * this.scaleY_;
        result.translateX_ = this.translateX_;
        result.translateY_ = this.translateY_;
        return result;
    }

    @JsxFunction
    public SVGMatrix rotateFromVector(double x, double y) {
        if (x == 0.0 || y == 0.0) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Failed to execute 'rotateFromVector' on 'SVGMatrix': Arguments cannot be zero.", 15);
        }
        double theta = Math.atan2(y, x);
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = -sin * this.scaleX_ + cos * this.shearX_;
        result.shearY_ = cos * this.shearY_ + sin * this.scaleY_;
        result.scaleX_ = cos * this.scaleX_ + sin * this.shearX_;
        result.scaleY_ = -sin * this.shearY_ + cos * this.scaleY_;
        result.translateX_ = this.translateX_;
        result.translateY_ = this.translateY_;
        return result;
    }

    @JsxFunction
    public SVGMatrix scale(double factor) {
        return this.scaleNonUniform(factor, factor);
    }

    @JsxFunction
    public SVGMatrix scaleNonUniform(double factorX, double factorY) {
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = factorY * this.shearX_;
        result.shearY_ = factorX * this.shearY_;
        result.scaleX_ = factorX * this.scaleX_;
        result.scaleY_ = factorY * this.scaleY_;
        result.translateX_ = this.translateX_;
        result.translateY_ = this.translateY_;
        return result;
    }

    @JsxFunction
    public SVGMatrix skewX(double angle) {
        double shear = Math.tan(Math.toRadians(angle));
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = shear * this.scaleX_ + this.shearX_;
        result.shearY_ = this.shearY_;
        result.scaleX_ = this.scaleX_;
        result.scaleY_ = shear * this.shearY_ + this.scaleY_;
        result.translateX_ = this.translateX_;
        result.translateY_ = this.translateY_;
        return result;
    }

    @JsxFunction
    public SVGMatrix skewY(double angle) {
        double shear = Math.tan(Math.toRadians(angle));
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = this.shearX_;
        result.shearY_ = this.shearY_ + shear * this.scaleY_;
        result.scaleX_ = this.scaleX_ + shear * this.shearX_;
        result.scaleY_ = this.scaleY_;
        result.translateX_ = this.translateX_;
        result.translateY_ = this.translateY_;
        return result;
    }

    @JsxFunction
    public SVGMatrix translate(double x, double y) {
        SVGMatrix result = new SVGMatrix(this.getWindow());
        result.shearX_ = this.shearX_;
        result.shearY_ = this.shearY_;
        result.scaleX_ = this.scaleX_;
        result.scaleY_ = this.scaleY_;
        result.translateX_ = x * this.scaleX_ + y * this.shearX_ + this.translateX_;
        result.translateY_ = x * this.shearY_ + y * this.scaleY_ + this.translateY_;
        return result;
    }
}

