/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlAbbreviated;
import org.htmlunit.html.HtmlAcronym;
import org.htmlunit.html.HtmlAddress;
import org.htmlunit.html.HtmlArticle;
import org.htmlunit.html.HtmlAside;
import org.htmlunit.html.HtmlBaseFont;
import org.htmlunit.html.HtmlBidirectionalIsolation;
import org.htmlunit.html.HtmlBidirectionalOverride;
import org.htmlunit.html.HtmlBig;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlBold;
import org.htmlunit.html.HtmlCenter;
import org.htmlunit.html.HtmlCitation;
import org.htmlunit.html.HtmlCode;
import org.htmlunit.html.HtmlDefinition;
import org.htmlunit.html.HtmlDefinitionDescription;
import org.htmlunit.html.HtmlDefinitionTerm;
import org.htmlunit.html.HtmlDivision;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlEmphasis;
import org.htmlunit.html.HtmlFigure;
import org.htmlunit.html.HtmlFigureCaption;
import org.htmlunit.html.HtmlFooter;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlHeader;
import org.htmlunit.html.HtmlItalic;
import org.htmlunit.html.HtmlKeyboard;
import org.htmlunit.html.HtmlLayer;
import org.htmlunit.html.HtmlMain;
import org.htmlunit.html.HtmlMark;
import org.htmlunit.html.HtmlNav;
import org.htmlunit.html.HtmlNoBreak;
import org.htmlunit.html.HtmlNoEmbed;
import org.htmlunit.html.HtmlNoFrames;
import org.htmlunit.html.HtmlNoLayer;
import org.htmlunit.html.HtmlNoScript;
import org.htmlunit.html.HtmlPlainText;
import org.htmlunit.html.HtmlRb;
import org.htmlunit.html.HtmlRp;
import org.htmlunit.html.HtmlRt;
import org.htmlunit.html.HtmlRtc;
import org.htmlunit.html.HtmlRuby;
import org.htmlunit.html.HtmlS;
import org.htmlunit.html.HtmlSample;
import org.htmlunit.html.HtmlSection;
import org.htmlunit.html.HtmlSmall;
import org.htmlunit.html.HtmlStrike;
import org.htmlunit.html.HtmlStrong;
import org.htmlunit.html.HtmlSubscript;
import org.htmlunit.html.HtmlSummary;
import org.htmlunit.html.HtmlSuperscript;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableDataCell;
import org.htmlunit.html.HtmlTeletype;
import org.htmlunit.html.HtmlUnderlined;
import org.htmlunit.html.HtmlVariable;
import org.htmlunit.html.HtmlWordBreak;
import org.htmlunit.html.serializer.HtmlSerializerInnerOuterText;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.ClientRect;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.css.CSSStyleDeclaration;
import org.htmlunit.javascript.host.dom.DOMStringMap;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.event.EventHandler;
import org.htmlunit.javascript.host.event.MouseEvent;
import org.htmlunit.javascript.host.html.HTMLBodyElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.util.StringUtils;

@JsxClasses(value={@JsxClass(domClass=HtmlAbbreviated.class), @JsxClass(domClass=HtmlAcronym.class), @JsxClass(domClass=HtmlAddress.class), @JsxClass(domClass=HtmlArticle.class), @JsxClass(domClass=HtmlAside.class), @JsxClass(domClass=HtmlBaseFont.class), @JsxClass(domClass=HtmlBidirectionalIsolation.class), @JsxClass(domClass=HtmlBidirectionalOverride.class), @JsxClass(domClass=HtmlBig.class), @JsxClass(domClass=HtmlBold.class), @JsxClass(domClass=HtmlCenter.class), @JsxClass(domClass=HtmlCitation.class), @JsxClass(domClass=HtmlCode.class), @JsxClass(domClass=HtmlDefinition.class), @JsxClass(domClass=HtmlDefinitionDescription.class), @JsxClass(domClass=HtmlDefinitionTerm.class), @JsxClass(domClass=HtmlElement.class, value={SupportedBrowser.FF, SupportedBrowser.FF_ESR}), @JsxClass(domClass=HtmlEmphasis.class), @JsxClass(domClass=HtmlFigure.class), @JsxClass(domClass=HtmlFigureCaption.class), @JsxClass(domClass=HtmlFooter.class), @JsxClass(domClass=HtmlHeader.class), @JsxClass(domClass=HtmlItalic.class), @JsxClass(domClass=HtmlKeyboard.class), @JsxClass(domClass=HtmlLayer.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlMark.class), @JsxClass(domClass=HtmlNav.class), @JsxClass(domClass=HtmlNoBreak.class), @JsxClass(domClass=HtmlNoEmbed.class), @JsxClass(domClass=HtmlNoFrames.class), @JsxClass(domClass=HtmlNoLayer.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlNoScript.class), @JsxClass(domClass=HtmlPlainText.class), @JsxClass(domClass=HtmlRuby.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlRb.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlRp.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlRt.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlRtc.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlS.class), @JsxClass(domClass=HtmlSample.class), @JsxClass(domClass=HtmlSection.class), @JsxClass(domClass=HtmlSmall.class), @JsxClass(domClass=HtmlStrike.class), @JsxClass(domClass=HtmlStrong.class), @JsxClass(domClass=HtmlSubscript.class), @JsxClass(domClass=HtmlSummary.class), @JsxClass(domClass=HtmlSuperscript.class), @JsxClass(domClass=HtmlTeletype.class), @JsxClass(domClass=HtmlUnderlined.class), @JsxClass(domClass=HtmlWordBreak.class), @JsxClass(domClass=HtmlMain.class), @JsxClass(domClass=HtmlVariable.class)})
public class HTMLElement
extends Element {
    private static final Class<?>[] METHOD_PARAMS_OBJECT = new Class[]{Object.class};
    private static final Set<String> ENTER_KEY_HINT_VALUES = new HashSet<String>();
    private boolean endTagForbidden_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    public void setDomNode(DomNode domNode) {
        HtmlForm form;
        super.setDomNode(domNode);
        String name = domNode.getLocalName();
        if ("wbr".equalsIgnoreCase(name) || "basefont".equalsIgnoreCase(name) || "track".equalsIgnoreCase(name)) {
            this.endTagForbidden_ = true;
        }
        if (("input".equalsIgnoreCase(name) || "button".equalsIgnoreCase(name) || "textarea".equalsIgnoreCase(name) || "select".equalsIgnoreCase(name)) && (form = ((HtmlElement)domNode).getEnclosingForm()) != null) {
            this.setParentScope((Scriptable)this.getScriptableFor(form));
        }
    }

    public HTMLFormElement getForm() {
        HtmlForm form = this.getDomNodeOrDie().getEnclosingForm();
        if (form == null) {
            return null;
        }
        return (HTMLFormElement)this.getScriptableFor(form);
    }

    @JsxGetter
    public String getTitle() {
        return this.getDomNodeOrDie().getAttributeDirect("title");
    }

    @JsxSetter
    public void setTitle(String newTitle) {
        this.getDomNodeOrDie().setAttribute("title", newTitle);
    }

    @JsxGetter
    public boolean getAutofocus() {
        return this.getDomNodeOrDie().hasAttribute("autofocus");
    }

    @JsxSetter
    public void setAutofocus(boolean newAutofocus) {
        if (newAutofocus) {
            this.getDomNodeOrDie().setAttribute("autofocus", "");
        } else {
            this.getDomNodeOrDie().removeAttribute("autofocus");
        }
    }

    public boolean isDisabled() {
        return this.getDomNodeOrDie().hasAttribute("disabled");
    }

    public void setDisabled(boolean disabled) {
        HtmlElement element = this.getDomNodeOrDie();
        if (disabled) {
            element.setAttribute("disabled", "disabled");
        } else {
            element.removeAttribute("disabled");
        }
    }

    @Override
    public String getLocalName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (domNode.getHtmlPageOrNull() != null) {
            String prefix = ((DomNode)domNode).getPrefix();
            if (prefix != null) {
                StringBuilder localName = new StringBuilder(StringUtils.toRootLowerCase(prefix)).append(':').append(StringUtils.toRootLowerCase(((DomNode)domNode).getLocalName()));
                return localName.toString();
            }
            return StringUtils.toRootLowerCase(((DomNode)domNode).getLocalName());
        }
        return ((DomNode)domNode).getLocalName();
    }

    @Override
    public void setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute((String)name, value);
        if (!((String)name).isEmpty() && ((String)(name = ((String)name).toLowerCase(Locale.ROOT))).startsWith("on")) {
            try {
                name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
                Method method = this.getClass().getMethod("set" + (String)name, METHOD_PARAMS_OBJECT);
                method.invoke((Object)this, new Object[]{new EventHandler(this.getDomNodeOrDie(), ((String)name).substring(2), value)});
            }
            catch (IllegalAccessException | NoSuchMethodException method) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @Override
    public HtmlUnitScriptable getAttributeNode(String attributeName) {
        return this.getAttributes().getNamedItem(attributeName);
    }

    @JsxGetter
    public String getInnerText() {
        HtmlSerializerInnerOuterText ser = new HtmlSerializerInnerOuterText(this.getBrowserVersion());
        return ser.asText(this.getDomNodeOrDie());
    }

    @JsxSetter
    public void setInnerText(Object value) {
        String valueString = value == null ? null : JavaScriptEngine.toString(value);
        HtmlElement domNode = this.getDomNodeOrDie();
        SgmlPage page = domNode.getPage();
        domNode.removeAllChildren();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)valueString)) {
            String[] parts = valueString.split("\\r?\\n");
            for (int i = 0; i < parts.length; ++i) {
                if (i != 0) {
                    domNode.appendChild(page.createElement("br"));
                }
                domNode.appendChild(new DomText(page, parts[i]));
            }
        }
    }

    @JsxGetter
    public String getOuterText() {
        return this.getInnerText();
    }

    @JsxSetter
    public void setOuterText(Object value) {
        String valueString = value == null ? null : JavaScriptEngine.toString(value);
        HtmlElement domNode = this.getDomNodeOrDie();
        SgmlPage page = domNode.getPage();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)valueString)) {
            domNode.getParentNode().insertBefore(new DomText(page, ""), domNode);
        } else {
            String[] parts = valueString.split("\\r?\\n");
            for (int i = 0; i < parts.length; ++i) {
                if (i != 0) {
                    domNode.getParentNode().insertBefore(page.createElement("br"), domNode);
                }
                domNode.getParentNode().insertBefore(new DomText(page, parts[i]), domNode);
            }
        }
        domNode.remove();
    }

    @Override
    public void setTextContent(Object value) {
        String textValue;
        HtmlElement domNode = this.getDomNodeOrDie();
        domNode.removeAllChildren();
        if (value != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(textValue = JavaScriptEngine.toString(value)))) {
            domNode.appendChild(new DomText(domNode.getPage(), textValue));
        }
    }

    @JsxGetter
    public int getOffsetHeight() {
        if (this.isDisplayNone() || !this.getDomNodeOrDie().isAttachedToPage()) {
            return 0;
        }
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.getClientY() - this.getPosY() + 50;
        }
        ComputedCssStyleDeclaration style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null);
        return style.getCalculatedHeight(true, true);
    }

    @JsxGetter
    public int getOffsetWidth() {
        if (this.isDisplayNone() || !this.getDomNodeOrDie().isAttachedToPage()) {
            return 0;
        }
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.getClientX() - this.getPosX() + 50;
        }
        ComputedCssStyleDeclaration style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null);
        return style.getCalculatedWidth(true, true);
    }

    protected boolean isAncestorOfEventTarget(MouseEvent event) {
        if (event == null) {
            return false;
        }
        if (!(event.getSrcElement() instanceof HTMLElement)) {
            return false;
        }
        HTMLElement srcElement = (HTMLElement)event.getSrcElement();
        return this.getDomNodeOrDie().isAncestorOf(srcElement.getDomNodeOrDie());
    }

    public String toString() {
        return "HTMLElement for " + String.valueOf(this.getDomNodeOrNull());
    }

    public HTMLElement getParentHTMLElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof HTMLElement); parent = parent.getParent()) {
        }
        return (HTMLElement)parent;
    }

    @Override
    public HtmlElement getDomNodeOrDie() {
        return (HtmlElement)super.getDomNodeOrDie();
    }

    @Override
    public HtmlElement getDomNodeOrNull() {
        return (HtmlElement)super.getDomNodeOrNull();
    }

    @JsxFunction
    public void blur() {
        this.getDomNodeOrDie().blur();
    }

    @JsxFunction
    public void focus() {
        this.getDomNodeOrDie().focus();
    }

    @Override
    public String getNodeName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        String nodeName = domNode.getNodeName();
        if (domNode.getHtmlPageOrNull() != null) {
            nodeName = nodeName.toUpperCase(Locale.ROOT);
        }
        return nodeName;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @JsxFunction
    public void click() throws IOException {
        this.getDomNodeOrDie().click(false, false, false, true, true, true, false);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public boolean isSpellcheck() {
        return JavaScriptEngine.toBoolean(this.getDomNodeOrDie().getAttributeDirect("spellcheck"));
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setSpellcheck(boolean spellcheck) {
        this.getDomNodeOrDie().setAttribute("spellcheck", Boolean.toString(spellcheck));
    }

    @JsxGetter
    public String getLang() {
        return this.getDomNodeOrDie().getAttributeDirect("lang");
    }

    @JsxSetter
    public void setLang(String lang) {
        this.getDomNodeOrDie().setAttribute("lang", lang);
    }

    @JsxGetter
    public String getDir() {
        return this.getDomNodeOrDie().getAttributeDirect("dir");
    }

    @JsxSetter
    public void setDir(String dir) {
        this.getDomNodeOrDie().setAttribute("dir", dir);
    }

    @JsxGetter
    public int getTabIndex() {
        return (int)JavaScriptEngine.toNumber(this.getDomNodeOrDie().getAttributeDirect("tabindex"));
    }

    @JsxSetter
    public void setTabIndex(int tabIndex) {
        this.getDomNodeOrDie().setAttribute("tabindex", Integer.toString(tabIndex));
    }

    @JsxGetter
    public String getAccessKey() {
        return this.getDomNodeOrDie().getAttributeDirect("accesskey");
    }

    @JsxSetter
    public void setAccessKey(String accessKey) {
        this.getDomNodeOrDie().setAttribute("accesskey", accessKey);
    }

    protected String getWidthOrHeight(String attributeName, Boolean returnNegativeValues) {
        return this.getDomNodeOrDie().getAttribute(attributeName);
    }

    protected void setWidthOrHeight(String attributeName, String value, boolean allowNegativeValues) {
        this.getDomNodeOrDie().setAttribute(attributeName, value);
    }

    protected void setColorAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    protected String getAlign(boolean returnInvalidValues) {
        return this.getDomNodeOrDie().getAttributeDirect("align");
    }

    protected void setAlign(String align, boolean ignoreIfNoError) {
        if (!ignoreIfNoError) {
            this.getDomNodeOrDie().setAttribute("align", align);
        }
    }

    protected String getVAlign(String[] valid, String defaultValue) {
        String valign = this.getDomNodeOrDie().getAttributeDirect("valign");
        String valignLC = valign.toLowerCase(Locale.ROOT);
        if (valid == null || ArrayUtils.contains((Object[])valid, (Object)valignLC)) {
            return valign;
        }
        return defaultValue;
    }

    protected void setVAlign(Object vAlign, String[] valid) {
        String valign = JavaScriptEngine.toString(vAlign);
        String valignLC = valign.toLowerCase(Locale.ROOT);
        if (valid != null && !ArrayUtils.contains((Object[])valid, (Object)valignLC)) {
            throw JavaScriptEngine.reportRuntimeError("Cannot set the vAlign property to invalid value: " + String.valueOf(vAlign));
        }
        this.getDomNodeOrDie().setAttribute("valign", valign);
    }

    protected String getCh() {
        return this.getDomNodeOrDie().getAttributeDirect("char");
    }

    protected void setCh(String ch) {
        this.getDomNodeOrDie().setAttribute("char", ch);
    }

    protected String getChOff() {
        return this.getDomNodeOrDie().getAttribute("charOff");
    }

    protected void setChOff(String chOff) {
        try {
            float f = Float.parseFloat(chOff);
            int i = (int)f;
            chOff = (float)i == f ? Integer.toString(i) : Float.toString(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.getDomNodeOrDie().setAttribute("charOff", chOff);
    }

    @JsxGetter
    public int getOffsetLeft() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int left = 0;
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptableObject();
        WebWindow webWindow = element.getWindow().getWebWindow();
        ComputedCssStyleDeclaration style = webWindow.getComputedStyle(element.getDomNodeOrDie(), null);
        left += style.getLeft(true, false, false);
        String position = style.getPositionWithInheritance();
        if ("absolute".equals(position) || "fixed".equals(position)) {
            return left;
        }
        HTMLElement offsetParent = this.getOffsetParent();
        for (node = node.getParentNode(); node != null && node.getScriptableObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptableObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptableObject();
            style = webWindow.getComputedStyle(element.getDomNodeOrDie(), null);
            left += style.getLeft(true, true, true);
        }
        if (offsetParent != null) {
            style = webWindow.getComputedStyle(offsetParent.getDomNodeOrDie(), null);
            left += style.getMarginLeftValue();
            left += style.getPaddingLeftValue();
        }
        return left;
    }

    public int getPosX() {
        HTMLElement element;
        int cumulativeOffset = 0;
        WebWindow webWindow = element.getWindow().getWebWindow();
        for (element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.getOffsetLeft();
            if (element == this) continue;
            ComputedCssStyleDeclaration style = webWindow.getComputedStyle(element.getDomNodeOrDie(), null);
            cumulativeOffset += style.getBorderLeftValue();
        }
        return cumulativeOffset;
    }

    public int getPosY() {
        HTMLElement element;
        int cumulativeOffset = 0;
        WebWindow webWindow = element.getWindow().getWebWindow();
        for (element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.getOffsetTop();
            if (element == this) continue;
            ComputedCssStyleDeclaration style = webWindow.getComputedStyle(element.getDomNodeOrDie(), null);
            cumulativeOffset += style.getBorderTopValue();
        }
        return cumulativeOffset;
    }

    private HTMLElement getOffsetParent() {
        HtmlUnitScriptable offsetParent = this.getOffsetParentInternal(false);
        if (offsetParent instanceof HTMLElement) {
            return (HTMLElement)offsetParent;
        }
        return null;
    }

    @JsxGetter
    public int getOffsetTop() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int top = 0;
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptableObject();
        WebWindow webWindow = element.getWindow().getWebWindow();
        ComputedCssStyleDeclaration style = webWindow.getComputedStyle(element.getDomNodeOrDie(), null);
        top += style.getTop(true, false, false);
        String position = style.getPositionWithInheritance();
        if ("absolute".equals(position) || "fixed".equals(position)) {
            return top;
        }
        HTMLElement offsetParent = this.getOffsetParent();
        for (node = node.getParentNode(); node != null && node.getScriptableObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptableObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptableObject();
            style = webWindow.getComputedStyle(element.getDomNodeOrDie(), null);
            top += style.getTop(false, true, true);
        }
        if (offsetParent != null) {
            style = webWindow.getComputedStyle(this.getDomNodeOrDie(), null);
            boolean thisElementHasTopMargin = style.getMarginTopValue() != 0;
            style = webWindow.getComputedStyle(offsetParent.getDomNodeOrDie(), null);
            if (!thisElementHasTopMargin) {
                top += style.getMarginTopValue();
            }
            top += style.getPaddingTopValue();
        }
        return top;
    }

    @JsxGetter(propertyName="offsetParent")
    public HtmlUnitScriptable getOffsetParent_js() {
        return this.getOffsetParentInternal(this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OFFSET_PARENT_NULL_IF_FIXED));
    }

    private HtmlUnitScriptable getOffsetParentInternal(boolean returnNullIfFixed) {
        DomNode currentElement = this.getDomNodeOrDie();
        if (currentElement.getParentNode() == null) {
            return null;
        }
        HTMLElement htmlElement = (HTMLElement)currentElement.getScriptableObject();
        if (returnNullIfFixed && "fixed".equals(htmlElement.getStyle().getStyleAttribute(StyleAttributes.Definition.POSITION, true))) {
            return null;
        }
        WebWindow webWindow = htmlElement.getWindow().getWebWindow();
        ComputedCssStyleDeclaration style = webWindow.getComputedStyle(htmlElement.getDomNodeOrDie(), null);
        String position = style.getPositionWithInheritance();
        boolean staticPos = "static".equals(position);
        while (currentElement != null) {
            HTMLElement parentElement;
            ComputedCssStyleDeclaration parentStyle;
            String parentPosition;
            DomNode parentNode = currentElement.getParentNode();
            if (parentNode instanceof HtmlBody || staticPos && parentNode instanceof HtmlTableDataCell || staticPos && parentNode instanceof HtmlTable) {
                return parentNode.getScriptableObject();
            }
            if (parentNode != null && parentNode.getScriptableObject() instanceof HTMLElement && !"static".equals(parentPosition = (parentStyle = webWindow.getComputedStyle((parentElement = (HTMLElement)parentNode.getScriptableObject()).getDomNodeOrDie(), null)).getPositionWithInheritance())) {
                return parentNode.getScriptableObject();
            }
            currentElement = currentElement.getParentNode();
        }
        return null;
    }

    @Override
    public ClientRect getBoundingClientRect() {
        ClientRect textRectangle = super.getBoundingClientRect();
        int left = this.getPosX();
        int top = this.getPosY();
        Object parentNode = this.getOffsetParentInternal(false);
        while (parentNode instanceof HTMLElement && !(parentNode instanceof HTMLBodyElement)) {
            HTMLElement elem = (HTMLElement)parentNode;
            left -= elem.getScrollLeft();
            top -= elem.getScrollTop();
            parentNode = elem.getParentNode();
        }
        textRectangle.setBottom(top + this.getOffsetHeight());
        textRectangle.setLeft(left);
        textRectangle.setRight(left + this.getOffsetWidth());
        textRectangle.setTop(top);
        return textRectangle;
    }

    @JsxGetter
    public DOMStringMap getDataset() {
        return new DOMStringMap(this);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }

    protected boolean isLowerCaseInOuterHtml() {
        return false;
    }

    @JsxSetter
    public void setOnchange(Object onchange) {
        this.setEventHandler("change", onchange);
    }

    @JsxGetter
    public Function getOnchange() {
        return this.getEventHandler("change");
    }

    @JsxGetter
    public Function getOnsubmit() {
        return this.getEventHandler("submit");
    }

    @JsxSetter
    public void setOnsubmit(Object onsubmit) {
        this.setEventHandler("submit", onsubmit);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnwheel() {
        return super.getOnwheel();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwheel(Object onwheel) {
        super.setOnwheel(onwheel);
    }

    @JsxGetter
    public String getContentEditable() {
        String attribute = this.getDomNodeOrDie().getAttribute("contentEditable");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == attribute) {
            return "inherit";
        }
        if (attribute == DomElement.ATTRIBUTE_VALUE_EMPTY) {
            return "true";
        }
        return attribute;
    }

    @JsxSetter
    public void setContentEditable(String contentEditable) {
        this.getDomNodeOrDie().setAttribute("contentEditable", contentEditable);
    }

    @JsxGetter
    public boolean isIsContentEditable() {
        Object parentScriptable;
        DomNode parent;
        String attribute = this.getContentEditable();
        if ("true".equals(attribute)) {
            return true;
        }
        if ("inherit".equals(attribute) && (parent = this.getDomNodeOrDie().getParentNode()) != null && (parentScriptable = parent.getScriptableObject()) instanceof HTMLElement) {
            return ((HTMLElement)parentScriptable).isIsContentEditable();
        }
        return false;
    }

    @Override
    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        return super.getStyle();
    }

    @Override
    @JsxSetter
    public void setStyle(String style) {
        super.setStyle(style);
    }

    @JsxSetter
    public void setOnclick(Object handler) {
        this.setEventHandler("click", handler);
    }

    @JsxGetter
    public Function getOnclick() {
        return this.getEventHandler("click");
    }

    @JsxSetter
    public void setOndblclick(Object handler) {
        this.setEventHandler("dblclick", handler);
    }

    @JsxGetter
    public Function getOndblclick() {
        return this.getEventHandler("dblclick");
    }

    @JsxSetter
    public void setOnblur(Object handler) {
        this.setEventHandler("blur", handler);
    }

    @JsxGetter
    public Function getOnblur() {
        return this.getEventHandler("blur");
    }

    @JsxSetter
    public void setOnfocus(Object handler) {
        this.setEventHandler("focus", handler);
    }

    @JsxGetter
    public Function getOnfocus() {
        return this.getEventHandler("focus");
    }

    @JsxSetter
    public void setOnkeydown(Object handler) {
        this.setEventHandler("keydown", handler);
    }

    @JsxGetter
    public Function getOnkeydown() {
        return this.getEventHandler("keydown");
    }

    @JsxSetter
    public void setOnkeypress(Object handler) {
        this.setEventHandler("keypress", handler);
    }

    @JsxGetter
    public Function getOnkeypress() {
        return this.getEventHandler("keypress");
    }

    @JsxSetter
    public void setOnkeyup(Object handler) {
        this.setEventHandler("keyup", handler);
    }

    @JsxGetter
    public Function getOnkeyup() {
        return this.getEventHandler("keyup");
    }

    @JsxSetter
    public void setOnmousedown(Object handler) {
        this.setEventHandler("mousedown", handler);
    }

    @JsxGetter
    public Function getOnmousedown() {
        return this.getEventHandler("mousedown");
    }

    @JsxSetter
    public void setOnmousemove(Object handler) {
        this.setEventHandler("mousemove", handler);
    }

    @JsxGetter
    public Function getOnmousemove() {
        return this.getEventHandler("mousemove");
    }

    @JsxSetter
    public void setOnmouseout(Object handler) {
        this.setEventHandler("mouseout", handler);
    }

    @JsxGetter
    public Function getOnmouseout() {
        return this.getEventHandler("mouseout");
    }

    @JsxSetter
    public void setOnmouseover(Object handler) {
        this.setEventHandler("mouseover", handler);
    }

    @JsxGetter
    public Function getOnmouseover() {
        return this.getEventHandler("mouseover");
    }

    @JsxSetter
    public void setOnmouseup(Object handler) {
        this.setEventHandler("mouseup", handler);
    }

    @JsxGetter
    public Function getOnmouseup() {
        return this.getEventHandler("mouseup");
    }

    @JsxSetter
    public void setOncontextmenu(Object handler) {
        this.setEventHandler("contextmenu", handler);
    }

    @JsxGetter
    public Function getOncontextmenu() {
        return this.getEventHandler("contextmenu");
    }

    @JsxSetter
    public void setOnresize(Object handler) {
        this.setEventHandler("resize", handler);
    }

    @JsxGetter
    public Function getOnresize() {
        return this.getEventHandler("resize");
    }

    @JsxSetter
    public void setOnerror(Object handler) {
        this.setEventHandler("error", handler);
    }

    @JsxGetter
    public Function getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxGetter
    public Function getOninput() {
        return this.getEventHandler("input");
    }

    @JsxSetter
    public void setOninput(Object oninput) {
        this.setEventHandler("input", oninput);
    }

    @JsxGetter
    public boolean isHidden() {
        return this.getDomNodeOrDie().isHidden();
    }

    @JsxSetter
    public void setHidden(Object hidden) {
        if (hidden instanceof Boolean) {
            this.getDomNodeOrDie().setHidden((Boolean)hidden);
            return;
        }
        this.getDomNodeOrDie().setHidden(JavaScriptEngine.toString(hidden));
    }

    @JsxGetter
    public Function getOnabort() {
        return this.getEventHandler("abort");
    }

    @JsxSetter
    public void setOnabort(Object onabort) {
        this.setEventHandler("abort", onabort);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnauxclick() {
        return this.getEventHandler("auxclick");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnauxclick(Object onauxclick) {
        this.setEventHandler("auxclick", onauxclick);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOncancel() {
        return this.getEventHandler("cancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOncancel(Object oncancel) {
        this.setEventHandler("cancel", oncancel);
    }

    @JsxGetter
    public Function getOncanplay() {
        return this.getEventHandler("canplay");
    }

    @JsxSetter
    public void setOncanplay(Object oncanplay) {
        this.setEventHandler("canplay", oncanplay);
    }

    @JsxGetter
    public Function getOncanplaythrough() {
        return this.getEventHandler("canplaythrough");
    }

    @JsxSetter
    public void setOncanplaythrough(Object oncanplaythrough) {
        this.setEventHandler("canplaythrough", oncanplaythrough);
    }

    @JsxGetter
    public Function getOnclose() {
        return this.getEventHandler("close");
    }

    @JsxSetter
    public void setOnclose(Object onclose) {
        this.setEventHandler("close", onclose);
    }

    @JsxGetter
    public Function getOncuechange() {
        return this.getEventHandler("cuechange");
    }

    @JsxSetter
    public void setOncuechange(Object oncuechange) {
        this.setEventHandler("cuechange", oncuechange);
    }

    @JsxGetter
    public Function getOndrag() {
        return this.getEventHandler("drag");
    }

    @JsxSetter
    public void setOndrag(Object ondrag) {
        this.setEventHandler("drag", ondrag);
    }

    @JsxGetter
    public Function getOndragend() {
        return this.getEventHandler("dragend");
    }

    @JsxSetter
    public void setOndragend(Object ondragend) {
        this.setEventHandler("dragend", ondragend);
    }

    @JsxGetter
    public Function getOndragenter() {
        return this.getEventHandler("dragenter");
    }

    @JsxSetter
    public void setOndragenter(Object ondragenter) {
        this.setEventHandler("dragenter", ondragenter);
    }

    @JsxGetter
    public Function getOndragleave() {
        return this.getEventHandler("dragleave");
    }

    @JsxSetter
    public void setOndragleave(Object ondragleave) {
        this.setEventHandler("dragleave", ondragleave);
    }

    @JsxGetter
    public Function getOndragover() {
        return this.getEventHandler("dragover");
    }

    @JsxSetter
    public void setOndragover(Object ondragover) {
        this.setEventHandler("dragover", ondragover);
    }

    @JsxGetter
    public Function getOndragstart() {
        return this.getEventHandler("dragstart");
    }

    @JsxSetter
    public void setOndragstart(Object ondragstart) {
        this.setEventHandler("dragstart", ondragstart);
    }

    @JsxGetter
    public Function getOndrop() {
        return this.getEventHandler("drop");
    }

    @JsxSetter
    public void setOndrop(Object ondrop) {
        this.setEventHandler("drop", ondrop);
    }

    @JsxGetter
    public Function getOndurationchange() {
        return this.getEventHandler("durationchange");
    }

    @JsxSetter
    public void setOndurationchange(Object ondurationchange) {
        this.setEventHandler("durationchange", ondurationchange);
    }

    @JsxGetter
    public Function getOnemptied() {
        return this.getEventHandler("emptied");
    }

    @JsxSetter
    public void setOnemptied(Object onemptied) {
        this.setEventHandler("emptied", onemptied);
    }

    @JsxGetter
    public Function getOnended() {
        return this.getEventHandler("ended");
    }

    @JsxSetter
    public void setOnended(Object onended) {
        this.setEventHandler("ended", onended);
    }

    @JsxGetter
    public Function getOngotpointercapture() {
        return this.getEventHandler("gotpointercapture");
    }

    @JsxSetter
    public void setOngotpointercapture(Object ongotpointercapture) {
        this.setEventHandler("gotpointercapture", ongotpointercapture);
    }

    @JsxGetter
    public Function getOninvalid() {
        return this.getEventHandler("invalid");
    }

    @JsxSetter
    public void setOninvalid(Object oninvalid) {
        this.setEventHandler("invalid", oninvalid);
    }

    @JsxGetter
    public Function getOnload() {
        if (this instanceof HTMLBodyElement) {
            return this.getWindow().getEventHandler("load");
        }
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        if (this instanceof HTMLBodyElement) {
            this.getWindow().setEventHandler("load", onload);
            return;
        }
        this.setEventHandler("load", onload);
    }

    @JsxGetter
    public Function getOnloadeddata() {
        return this.getEventHandler("loadeddata");
    }

    @JsxSetter
    public void setOnloadeddata(Object onloadeddata) {
        this.setEventHandler("loadeddata", onloadeddata);
    }

    @JsxGetter
    public Function getOnloadedmetadata() {
        return this.getEventHandler("loadedmetadata");
    }

    @JsxSetter
    public void setOnloadedmetadata(Object onloadedmetadata) {
        this.setEventHandler("loadedmetadata", onloadedmetadata);
    }

    @JsxGetter
    public Function getOnloadstart() {
        return this.getEventHandler("loadstart");
    }

    @JsxSetter
    public void setOnloadstart(Object onloadstart) {
        this.setEventHandler("loadstart", onloadstart);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnlostpointercapture() {
        return this.getEventHandler("lostpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnlostpointercapture(Object onlostpointercapture) {
        this.setEventHandler("lostpointercapture", onlostpointercapture);
    }

    @JsxGetter
    public Function getOnmouseenter() {
        return this.getEventHandler("mouseenter");
    }

    @JsxSetter
    public void setOnmouseenter(Object onmouseenter) {
        this.setEventHandler("mouseenter", onmouseenter);
    }

    @JsxGetter
    public Function getOnmouseleave() {
        return this.getEventHandler("mouseleave");
    }

    @JsxSetter
    public void setOnmouseleave(Object onmouseleave) {
        this.setEventHandler("mouseleave", onmouseleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnmousewheel() {
        return this.getEventHandler("mousewheel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnmousewheel(Object onmousewheel) {
        this.setEventHandler("mousewheel", onmousewheel);
    }

    @JsxGetter
    public Function getOnpause() {
        return this.getEventHandler("pause");
    }

    @JsxSetter
    public void setOnpause(Object onpause) {
        this.setEventHandler("pause", onpause);
    }

    @JsxGetter
    public Function getOnplay() {
        return this.getEventHandler("play");
    }

    @JsxSetter
    public void setOnplay(Object onplay) {
        this.setEventHandler("play", onplay);
    }

    @JsxGetter
    public Function getOnplaying() {
        return this.getEventHandler("playing");
    }

    @JsxSetter
    public void setOnplaying(Object onplaying) {
        this.setEventHandler("playing", onplaying);
    }

    @JsxGetter
    public Function getOnpointercancel() {
        return this.getEventHandler("pointercancel");
    }

    @JsxSetter
    public void setOnpointercancel(Object onpointercancel) {
        this.setEventHandler("pointercancel", onpointercancel);
    }

    @JsxGetter
    public Function getOnpointerdown() {
        return this.getEventHandler("pointerdown");
    }

    @JsxSetter
    public void setOnpointerdown(Object onpointerdown) {
        this.setEventHandler("pointerdown", onpointerdown);
    }

    @JsxGetter
    public Function getOnpointerenter() {
        return this.getEventHandler("pointerenter");
    }

    @JsxSetter
    public void setOnpointerenter(Object onpointerenter) {
        this.setEventHandler("pointerenter", onpointerenter);
    }

    @JsxGetter
    public Function getOnpointerleave() {
        return this.getEventHandler("pointerleave");
    }

    @JsxSetter
    public void setOnpointerleave(Object onpointerleave) {
        this.setEventHandler("pointerleave", onpointerleave);
    }

    @JsxGetter
    public Function getOnpointermove() {
        return this.getEventHandler("pointermove");
    }

    @JsxSetter
    public void setOnpointermove(Object onpointermove) {
        this.setEventHandler("pointermove", onpointermove);
    }

    @JsxGetter
    public Function getOnpointerout() {
        return this.getEventHandler("pointerout");
    }

    @JsxSetter
    public void setOnpointerout(Object onpointerout) {
        this.setEventHandler("pointerout", onpointerout);
    }

    @JsxGetter
    public Function getOnpointerover() {
        return this.getEventHandler("pointerover");
    }

    @JsxSetter
    public void setOnpointerover(Object onpointerover) {
        this.setEventHandler("pointerover", onpointerover);
    }

    @JsxGetter
    public Function getOnpointerup() {
        return this.getEventHandler("pointerup");
    }

    @JsxSetter
    public void setOnpointerup(Object onpointerup) {
        this.setEventHandler("pointerup", onpointerup);
    }

    @JsxGetter
    public Function getOnprogress() {
        return this.getEventHandler("progress");
    }

    @JsxSetter
    public void setOnprogress(Object onprogress) {
        this.setEventHandler("progress", onprogress);
    }

    @JsxGetter
    public Function getOnratechange() {
        return this.getEventHandler("ratechange");
    }

    @JsxSetter
    public void setOnratechange(Object onratechange) {
        this.setEventHandler("ratechange", onratechange);
    }

    @JsxGetter
    public Function getOnreset() {
        return this.getEventHandler("reset");
    }

    @JsxSetter
    public void setOnreset(Object onreset) {
        this.setEventHandler("reset", onreset);
    }

    @JsxGetter
    public Function getOnscroll() {
        return this.getEventHandler("scroll");
    }

    @JsxSetter
    public void setOnscroll(Object onscroll) {
        this.setEventHandler("scroll", onscroll);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF})
    public Function getOnscrollend() {
        return this.getEventHandler("scrollend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF})
    public void setOnscrollend(Object onscrollend) {
        this.setEventHandler("scrollend", onscrollend);
    }

    @JsxGetter
    public Function getOnseeked() {
        return this.getEventHandler("seeked");
    }

    @JsxSetter
    public void setOnseeked(Object onseeked) {
        this.setEventHandler("seeked", onseeked);
    }

    @JsxGetter
    public Function getOnseeking() {
        return this.getEventHandler("seeking");
    }

    @JsxSetter
    public void setOnseeking(Object onseeking) {
        this.setEventHandler("seeking", onseeking);
    }

    @JsxGetter
    public Function getOnselect() {
        return this.getEventHandler("select");
    }

    @JsxSetter
    public void setOnselect(Object onselect) {
        this.setEventHandler("select", onselect);
    }

    @JsxGetter
    public Function getOnstalled() {
        return this.getEventHandler("stalled");
    }

    @JsxSetter
    public void setOnstalled(Object onstalled) {
        this.setEventHandler("stalled", onstalled);
    }

    @JsxGetter
    public Function getOnsuspend() {
        return this.getEventHandler("suspend");
    }

    @JsxSetter
    public void setOnsuspend(Object onsuspend) {
        this.setEventHandler("suspend", onsuspend);
    }

    @JsxGetter
    public Function getOntimeupdate() {
        return this.getEventHandler("timeupdate");
    }

    @JsxSetter
    public void setOntimeupdate(Object ontimeupdate) {
        this.setEventHandler("timeupdate", ontimeupdate);
    }

    @JsxGetter
    public Function getOntoggle() {
        return this.getEventHandler("toggle");
    }

    @JsxSetter
    public void setOntoggle(Object ontoggle) {
        this.setEventHandler("toggle", ontoggle);
    }

    @JsxGetter
    public Function getOnvolumechange() {
        return this.getEventHandler("volumechange");
    }

    @JsxSetter
    public void setOnvolumechange(Object onvolumechange) {
        this.setEventHandler("volumechange", onvolumechange);
    }

    @JsxGetter
    public Function getOnwaiting() {
        return this.getEventHandler("waiting");
    }

    @JsxSetter
    public void setOnwaiting(Object onwaiting) {
        this.setEventHandler("waiting", onwaiting);
    }

    @JsxGetter
    public Function getOncopy() {
        return this.getEventHandler("copy");
    }

    @JsxSetter
    public void setOncopy(Object oncopy) {
        this.setEventHandler("copy", oncopy);
    }

    @JsxGetter
    public Function getOncut() {
        return this.getEventHandler("cut");
    }

    @JsxSetter
    public void setOncut(Object oncut) {
        this.setEventHandler("cut", oncut);
    }

    @JsxGetter
    public Function getOnpaste() {
        return this.getEventHandler("paste");
    }

    @JsxSetter
    public void setOnpaste(Object onpaste) {
        this.setEventHandler("paste", onpaste);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnmozfullscreenchange() {
        return this.getEventHandler("mozfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmozfullscreenchange(Object onmozfullscreenchange) {
        this.setEventHandler("mozfullscreenchange", onmozfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnmozfullscreenerror() {
        return this.getEventHandler("mozfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmozfullscreenerror(Object onmozfullscreenerror) {
        this.setEventHandler("mozfullscreenerror", onmozfullscreenerror);
    }

    @JsxGetter
    public Function getOnselectstart() {
        return this.getEventHandler("selectstart");
    }

    @JsxSetter
    public void setOnselectstart(Object onselectstart) {
        this.setEventHandler("selectstart", onselectstart);
    }

    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    public void setName(String newName) {
        this.getDomNodeOrDie().setAttribute("name", newName);
    }

    public Object getValue() {
        return this.getDomNodeOrDie().getAttributeDirect("value");
    }

    public void setValue(Object newValue) {
        this.getDomNodeOrDie().setAttribute("value", JavaScriptEngine.toString(newValue));
    }

    @JsxGetter
    public String getEnterKeyHint() {
        String value = this.getDomNodeOrDie().getAttributeDirect("enterkeyhint");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value || DomElement.ATTRIBUTE_VALUE_EMPTY == value) {
            return "";
        }
        if (ENTER_KEY_HINT_VALUES.contains(value = value.toLowerCase(Locale.ROOT))) {
            return value;
        }
        return "";
    }

    @JsxSetter
    public void setEnterKeyHint(Object enterKeyHint) {
        if (enterKeyHint == null || JavaScriptEngine.isUndefined(enterKeyHint)) {
            this.getDomNodeOrDie().removeAttribute("enterkeyhint");
            return;
        }
        this.getDomNodeOrDie().setAttribute("enterkeyhint", JavaScriptEngine.toString(enterKeyHint));
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnanimationcancel() {
        return this.getEventHandler("animationcancel");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnanimationcancel(Object onanimationcancel) {
        this.setEventHandler("animationcancel", onanimationcancel);
    }

    @JsxGetter
    public Function getOnanimationend() {
        return this.getEventHandler("animationend");
    }

    @JsxSetter
    public void setOnanimationend(Object onanimationend) {
        this.setEventHandler("animationend", onanimationend);
    }

    @JsxGetter
    public Function getOnanimationiteration() {
        return this.getEventHandler("animationiteration");
    }

    @JsxSetter
    public void setOnanimationiteration(Object onanimationiteration) {
        this.setEventHandler("animationiteration", onanimationiteration);
    }

    @JsxGetter
    public Function getOnanimationstart() {
        return this.getEventHandler("animationstart");
    }

    @JsxSetter
    public void setOnanimationstart(Object onanimationstart) {
        this.setEventHandler("animationstart", onanimationstart);
    }

    @JsxGetter
    public Function getOnselectionchange() {
        return this.getEventHandler("selectionchange");
    }

    @JsxSetter
    public void setOnselectionchange(Object onselectionchange) {
        this.setEventHandler("selectionchange", onselectionchange);
    }

    @JsxGetter
    public Function getOntransitioncancel() {
        return this.getEventHandler("ontransitioncancel");
    }

    @JsxSetter
    public void setOntransitioncancel(Object ontransitioncancel) {
        this.setEventHandler("ontransitioncancel", ontransitioncancel);
    }

    @JsxGetter
    public Function getOntransitionend() {
        return this.getEventHandler("ontransitionend");
    }

    @JsxSetter
    public void setOntransitionend(Object ontransitionend) {
        this.setEventHandler("ontransitionend", ontransitionend);
    }

    @JsxGetter
    public Function getOntransitionrun() {
        return this.getEventHandler("ontransitionrun");
    }

    @JsxSetter
    public void setOntransitionrun(Object ontransitionrun) {
        this.setEventHandler("ontransitionrun", ontransitionrun);
    }

    @JsxGetter
    public Function getOntransitionstart() {
        return this.getEventHandler("ontransitionstart");
    }

    @JsxSetter
    public void setOntransitionstart(Object ontransitionstart) {
        this.setEventHandler("ontransitionstart", ontransitionstart);
    }

    static {
        ENTER_KEY_HINT_VALUES.add("enter");
        ENTER_KEY_HINT_VALUES.add("done");
        ENTER_KEY_HINT_VALUES.add("go");
        ENTER_KEY_HINT_VALUES.add("next");
        ENTER_KEY_HINT_VALUES.add("previous");
        ENTER_KEY_HINT_VALUES.add("search");
        ENTER_KEY_HINT_VALUES.add("send");
    }

    public static class ProxyDomNode
    extends HtmlDivision {
        private final DomNode target_;
        private final boolean append_;

        public ProxyDomNode(SgmlPage page, DomNode target, boolean append) {
            super("div", page, null);
            this.target_ = target;
            this.append_ = append;
        }

        @Override
        public DomNode appendChild(org.w3c.dom.Node node) {
            DomNode domNode = (DomNode)node;
            if (this.append_) {
                return this.target_.appendChild(domNode);
            }
            this.target_.insertBefore(domNode);
            return domNode;
        }

        public DomNode getDomNode() {
            return this.target_;
        }

        public boolean isAppend() {
            return this.append_;
        }
    }
}

