/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.List;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.NodeList;

@JsxClass
public class RadioNodeList
extends NodeList {
    public RadioNodeList() {
    }

    public RadioNodeList(DomNode domNode) {
        super(domNode, true);
    }

    public RadioNodeList(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive);
    }

    public RadioNodeList(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, initialElements);
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public String getValue() {
        for (DomNode node : this.getElements()) {
            if (!(node instanceof HtmlRadioButtonInput) || !((HtmlRadioButtonInput)node).isChecked()) continue;
            String value = ((HtmlRadioButtonInput)node).getValueAttribute();
            return value == DomElement.ATTRIBUTE_NOT_DEFINED ? "on" : value;
        }
        return "";
    }

    @JsxSetter
    public void setValue(String newValue) {
        for (DomNode node : this.getElements()) {
            if (!(node instanceof HtmlRadioButtonInput)) continue;
            String value = ((HtmlRadioButtonInput)node).getValueAttribute();
            if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
                value = "on";
            }
            if (!newValue.equals(value)) continue;
            ((HtmlRadioButtonInput)node).setChecked(true);
            break;
        }
    }

    @JsxSymbol
    public Scriptable iterator() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), (Scriptable)this);
    }
}

