/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSCharsetRuleImpl;
import org.htmlunit.cssparser.dom.CSSMediaRuleImpl;
import org.htmlunit.cssparser.dom.CSSRuleListImpl;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSRuleList;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.w3c.dom.DOMException;

@JsxClass
public class CSSGroupingRule
extends CSSRule {
    private CSSRuleList cssRules_;
    private List<Integer> cssRulesIndexFix_;

    public CSSGroupingRule() {
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    protected CSSGroupingRule(CSSStyleSheet stylesheet, CSSMediaRuleImpl rule) {
        super(stylesheet, (AbstractCSSRuleImpl)rule);
    }

    @JsxGetter
    public CSSRuleList getCssRules() {
        this.initCssRules();
        return this.cssRules_;
    }

    @JsxFunction
    public int insertRule(String rule, Object position) {
        int positionInt = position == null ? 0 : (JavaScriptEngine.isUndefined(position) ? 0 : JavaScriptEngine.toInt32(position));
        try {
            this.initCssRules();
            this.getGroupingRule().insertRule(rule, this.fixIndex(positionInt));
            this.refreshCssRules();
            return positionInt;
        }
        catch (DOMException e) {
            int pos = rule.indexOf(123);
            if (pos > -1) {
                String newRule = rule.substring(0, pos) + "{}";
                try {
                    this.getGroupingRule().insertRule(newRule, this.fixIndex(positionInt));
                    this.refreshCssRules();
                    return positionInt;
                }
                catch (DOMException ex) {
                    throw JavaScriptEngine.asJavaScriptException(this.getWindow(), ex.getMessage(), ex.code);
                }
            }
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), e.getMessage(), 12);
        }
    }

    @JsxFunction
    public void deleteRule(int position) {
        try {
            this.initCssRules();
            this.getGroupingRule().deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), e.getMessage(), e.code);
        }
    }

    private void initCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
            this.cssRulesIndexFix_ = new ArrayList<Integer>();
            this.refreshCssRules();
        }
    }

    private int fixIndex(int index) {
        for (int fix : this.cssRulesIndexFix_) {
            if (fix > index) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private void refreshCssRules() {
        if (this.cssRules_ == null) {
            return;
        }
        this.cssRules_.clearRules();
        this.cssRulesIndexFix_.clear();
        CSSRuleListImpl ruleList = this.getGroupingRule().getCssRules();
        List rules = ruleList.getRules();
        int pos = 0;
        for (AbstractCSSRuleImpl rule : rules) {
            if (rule instanceof CSSCharsetRuleImpl) {
                this.cssRulesIndexFix_.add(pos);
                continue;
            }
            CSSRule cssRule = CSSRule.create(this.getParentStyleSheet(), rule);
            if (null == cssRule) {
                this.cssRulesIndexFix_.add(pos);
            } else {
                this.cssRules_.addRule(cssRule);
            }
            ++pos;
        }
    }

    private CSSMediaRuleImpl getGroupingRule() {
        return (CSSMediaRuleImpl)this.getRule();
    }
}

