/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;
import org.htmlunit.cyberneko.xerces.util.StandardEncodingTranslator;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.util.XUserDefinedCharset;

@JsxClass
public class TextDecoder
extends HtmlUnitScriptable {
    private String whatwgEncoding_ = "utf-8";

    @JsxConstructor
    public void jsConstructor(Object encodingLabel) {
        if (JavaScriptEngine.isUndefined(encodingLabel)) {
            return;
        }
        String enc = JavaScriptEngine.toString(encodingLabel);
        String whatwgEncoding = (String)StandardEncodingTranslator.ENCODING_FROM_LABEL.get(enc = enc.trim().toLowerCase(Locale.ROOT));
        if (whatwgEncoding == null || "replacement".equalsIgnoreCase(whatwgEncoding)) {
            throw JavaScriptEngine.rangeError("Failed to construct 'TextDecoder': The encoding label provided ('" + String.valueOf(encodingLabel) + "') is invalid.");
        }
        this.whatwgEncoding_ = whatwgEncoding;
    }

    @JsxGetter
    public String getEncoding() {
        return this.whatwgEncoding_;
    }

    @JsxFunction
    public String decode(Object buffer) {
        NativeArrayBufferView arrayBufferView;
        NativeArrayBuffer arrayBuffer;
        if (JavaScriptEngine.isUndefined(buffer)) {
            return "";
        }
        if (buffer instanceof NativeArrayBuffer) {
            return new String(((NativeArrayBuffer)buffer).getBuffer(), this.getEncoding(this.whatwgEncoding_));
        }
        if (buffer instanceof NativeArrayBufferView && (arrayBuffer = (arrayBufferView = (NativeArrayBufferView)buffer).getBuffer()) != null) {
            int byteLength = arrayBufferView.getByteLength();
            int byteOffset = arrayBufferView.getByteOffset();
            byte[] backedBytes = arrayBuffer.getBuffer();
            byte[] bytes = Arrays.copyOfRange(backedBytes, byteOffset, byteOffset + byteLength);
            return new String(bytes, this.getEncoding(this.whatwgEncoding_));
        }
        throw JavaScriptEngine.typeError("Argument 1 of TextDecoder.decode could not be converted to any of: ArrayBufferView, ArrayBuffer.");
    }

    private Charset getEncoding(String encodingLabel) {
        if ("x-user-defined".equalsIgnoreCase(encodingLabel)) {
            return XUserDefinedCharset.INSTANCE;
        }
        String ianaEncoding = StandardEncodingTranslator.ENCODING_TO_IANA_ENCODING.getOrDefault(encodingLabel, encodingLabel);
        String javaEncoding = StandardEncodingTranslator.IANA_TO_JAVA_ENCODINGS.getOrDefault(ianaEncoding, ianaEncoding);
        return Charset.forName(javaEncoding);
    }
}

