/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.Plugin;

@JsxClass
public class PluginArray
extends HtmlUnitScriptable {
    private final List<Plugin> elements_ = new ArrayList<Plugin>();

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxFunction
    public Plugin item(int index) {
        if (index >= 0 && index < this.elements_.size()) {
            return this.elements_.get(index);
        }
        return null;
    }

    @Override
    protected Object getWithPreemption(String name) {
        Plugin response = this.namedItem(name);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    public boolean has(String name, Scriptable start) {
        if (NOT_FOUND != this.getWithPreemption(name)) {
            return true;
        }
        return super.has(name, start);
    }

    public final Plugin get(int index, Scriptable start) {
        PluginArray array = (PluginArray)start;
        List<Plugin> elements = array.elements_;
        if (index >= 0 && index < elements.size()) {
            return elements.get(index);
        }
        return null;
    }

    @JsxFunction
    public Plugin namedItem(String name) {
        for (Plugin element : this.elements_) {
            if (!name.equals(this.getItemName(element))) continue;
            return element;
        }
        return null;
    }

    @JsxGetter
    public int getLength() {
        return this.elements_.size();
    }

    @JsxFunction
    public void refresh(boolean reloadDocuments) {
    }

    protected String getItemName(Object element) {
        return ((Plugin)element).getName();
    }

    void add(Plugin element) {
        this.elements_.add(element);
    }

    @JsxSymbol
    public Scriptable iterator() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), (Scriptable)this);
    }
}

