/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.background;

import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.ContextFactory;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.javascript.background.BasicJavaScriptJob;
import org.htmlunit.javascript.background.DefaultJavaScriptExecutor;
import org.htmlunit.javascript.background.JavaScriptExecutor;
import org.htmlunit.javascript.background.JavaScriptFunctionJob;
import org.htmlunit.javascript.background.JavaScriptJob;
import org.htmlunit.javascript.background.JavaScriptJobManager;
import org.htmlunit.javascript.background.JavaScriptJobManagerImpl;
import org.htmlunit.javascript.background.JavaScriptStringJob;
import org.htmlunit.javascript.background.JavascriptXMLHttpRequestJob;

public class BackgroundJavaScriptFactory {
    private static BackgroundJavaScriptFactory Factory_ = new BackgroundJavaScriptFactory();

    public static BackgroundJavaScriptFactory theFactory() {
        return Factory_;
    }

    public static void setFactory(BackgroundJavaScriptFactory factory) {
        Factory_ = factory;
    }

    public JavaScriptJob createJavaScriptJob(int initialDelay, Integer period, String label, WebWindow window, String script) {
        return new JavaScriptStringJob(initialDelay, period, label, window, script);
    }

    public JavaScriptFunctionJob createJavaScriptJob(int initialDelay, Integer period, String label, WebWindow window, Function function, Object[] args) {
        return new JavaScriptFunctionJob(initialDelay, period, label, window, function, args);
    }

    public JavaScriptJob createJavascriptXMLHttpRequestJob(ContextFactory contextFactory, ContextAction<Object> action) {
        return new JavascriptXMLHttpRequestJob(contextFactory, action);
    }

    public JavaScriptJob createJavaScriptJob(int initialDelay, Integer period, final Runnable runnable) {
        return new BasicJavaScriptJob(this, initialDelay, period){

            @Override
            public void run() {
                runnable.run();
            }
        };
    }

    public JavaScriptExecutor createJavaScriptExecutor(WebClient webClient) {
        return new DefaultJavaScriptExecutor(webClient);
    }

    public JavaScriptJobManager createJavaScriptJobManager(WebWindow webWindow) {
        return new JavaScriptJobManagerImpl(webWindow);
    }

    protected BackgroundJavaScriptFactory() {
    }
}

