/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.httpclient;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.htmlunit.BrowserVersion;
import org.htmlunit.httpclient.HtmlUnitBrowserCompatCookieSpec;
import org.htmlunit.util.Cookie;
import org.htmlunit.util.UrlUtils;

public final class HttpClientConverter {
    @Deprecated
    public static final int OK = 200;
    @Deprecated
    public static final int NO_CONTENT = 204;
    @Deprecated
    public static final int MULTIPLE_CHOICES = 300;
    @Deprecated
    public static final int MOVED_PERMANENTLY = 301;
    @Deprecated
    public static final int MOVED_TEMPORARILY = 302;
    @Deprecated
    public static final int SEE_OTHER = 303;
    @Deprecated
    public static final int TEMPORARY_REDIRECT = 307;
    @Deprecated
    public static final int PERMANENT_REDIRECT = 308;
    @Deprecated
    public static final int NOT_MODIFIED = 304;
    @Deprecated
    public static final int USE_PROXY = 305;
    @Deprecated
    public static final int FORBIDDEN = 403;
    @Deprecated
    public static final int NOT_FOUND = 404;
    @Deprecated
    public static final int INTERNAL_SERVER_ERROR = 500;

    private HttpClientConverter() {
    }

    public static List<NameValuePair> nameValuePairsToHttpClient(List<org.htmlunit.util.NameValuePair> pairs) {
        ArrayList<NameValuePair> resultingPairs = new ArrayList<NameValuePair>(pairs.size());
        for (org.htmlunit.util.NameValuePair pair : pairs) {
            resultingPairs.add((NameValuePair)new BasicNameValuePair(pair.getName(), pair.getValue()));
        }
        return resultingPairs;
    }

    @Deprecated
    public static List<org.htmlunit.util.NameValuePair> parseUrlQuery(String query, Charset charset) {
        List pairs = URLEncodedUtils.parse((String)query, (Charset)charset);
        ArrayList<org.htmlunit.util.NameValuePair> resultingPairs = new ArrayList<org.htmlunit.util.NameValuePair>();
        for (NameValuePair pair : pairs) {
            resultingPairs.add(new org.htmlunit.util.NameValuePair(pair.getName(), pair.getValue()));
        }
        return resultingPairs;
    }

    @Deprecated
    public static String toQueryFormFields(List<org.htmlunit.util.NameValuePair> parameters, Charset enc) {
        return URLEncodedUtils.format(HttpClientConverter.nameValuePairsToHttpClient(parameters), (Charset)enc);
    }

    @Deprecated
    public static Date parseHttpDate(String s) {
        if (s == null) {
            return null;
        }
        return DateUtils.parseDate((String)s);
    }

    @Deprecated
    public static String formatDate(Date date) {
        return DateUtils.formatDate((Date)date);
    }

    public static boolean isNoHttpResponseException(Exception e) {
        return e instanceof NoHttpResponseException;
    }

    public static CookieOrigin buildCookieOrigin(URL url) {
        URL normalizedUrl = HttpClientConverter.replaceForCookieIfNecessary(url);
        int port = normalizedUrl.getPort();
        if (port == -1) {
            port = normalizedUrl.getDefaultPort();
        }
        return new CookieOrigin(normalizedUrl.getHost(), port, normalizedUrl.getPath(), "https".equals(normalizedUrl.getProtocol()));
    }

    public static URL replaceForCookieIfNecessary(URL url) {
        String protocol = url.getProtocol();
        boolean file = "file".equals(protocol);
        if (file) {
            try {
                url = UrlUtils.getUrlWithNewHostAndPort(url, "LOCAL_FILESYSTEM", 0);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    public static List<Cookie> parseCookie(String cookieString, URL pageUrl, BrowserVersion browserVersion) throws MalformedCookieException {
        CharArrayBuffer buffer = new CharArrayBuffer(cookieString.length() + 22);
        buffer.append("Set-Cookie: ");
        buffer.append(cookieString);
        HtmlUnitBrowserCompatCookieSpec cookieSpec = new HtmlUnitBrowserCompatCookieSpec(browserVersion);
        List cookies = cookieSpec.parse((Header)new BufferedHeader(buffer), HttpClientConverter.buildCookieOrigin(pageUrl));
        ArrayList<Cookie> htmlUnitCookies = new ArrayList<Cookie>(cookies.size());
        for (org.apache.http.cookie.Cookie cookie : cookies) {
            Cookie htmlUnitCookie = new Cookie((ClientCookie)cookie);
            htmlUnitCookies.add(htmlUnitCookie);
        }
        return htmlUnitCookies;
    }

    public static List<org.apache.http.cookie.Cookie> toHttpClient(Collection<Cookie> cookies) {
        ArrayList<org.apache.http.cookie.Cookie> array = new ArrayList<org.apache.http.cookie.Cookie>(cookies.size());
        for (Cookie cookie : cookies) {
            array.add(cookie.toHttpClient());
        }
        return array;
    }

    public static List<Cookie> fromHttpClient(List<org.apache.http.cookie.Cookie> cookies) {
        ArrayList<Cookie> list = new ArrayList<Cookie>(cookies.size());
        for (org.apache.http.cookie.Cookie c : cookies) {
            list.add(new Cookie((ClientCookie)c));
        }
        return list;
    }

    public static void addMatching(Set<Cookie> cookies, URL normalizedUrl, BrowserVersion browserVersion, Set<Cookie> matches) {
        if (!cookies.isEmpty()) {
            CookieOrigin cookieOrigin = HttpClientConverter.buildCookieOrigin(normalizedUrl);
            HtmlUnitBrowserCompatCookieSpec cookieSpec = new HtmlUnitBrowserCompatCookieSpec(browserVersion);
            for (Cookie cookie : cookies) {
                if (!cookieSpec.match(cookie.toHttpClient(), cookieOrigin)) continue;
                matches.add(cookie);
            }
        }
    }
}

