/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.httpclient;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;

final class HtmlUnitDomainHandler
extends BasicDomainHandler {
    private final BrowserVersion browserVersion_;

    HtmlUnitDomainHandler(BrowserVersion browserVersion) {
        this.browserVersion_ = browserVersion;
    }

    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        if (TextUtils.isBlank((CharSequence)value)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        if (value.endsWith(".")) {
            return;
        }
        Object domain = value.toLowerCase(Locale.ROOT);
        int dotIndex = ((String)domain).indexOf(46);
        if (this.browserVersion_.hasFeature(BrowserVersionFeatures.HTTP_COOKIE_REMOVE_DOT_FROM_ROOT_DOMAINS) && dotIndex == 0 && ((String)domain).length() > 1 && ((String)domain).indexOf(46, 1) == -1) {
            domain = ((String)domain).substring(1);
        }
        if (dotIndex > 0) {
            domain = "." + (String)domain;
        }
        cookie.setDomain((String)domain);
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        int dotIndex = domain.indexOf(46);
        if (dotIndex == 0 && domain.length() > 1 && domain.indexOf(46, 1) == -1) {
            String host = origin.getHost();
            if (this.browserVersion_.hasFeature(BrowserVersionFeatures.HTTP_COOKIE_REMOVE_DOT_FROM_ROOT_DOMAINS)) {
                domain = domain.substring(1);
            }
            return host.equalsIgnoreCase(domain);
        }
        if (dotIndex == -1 && !"LOCAL_FILESYSTEM".equalsIgnoreCase(domain)) {
            try {
                InetAddress.getByName(domain);
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        return super.match(cookie, origin);
    }
}

