/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.util.Map;
import org.htmlunit.Page;
import org.htmlunit.ScriptResult;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.util.StringUtils;

public class HtmlRadioButtonInput
extends HtmlInput
implements LabelableElement {
    private static final String DEFAULT_VALUE = "on";
    private boolean defaultCheckedState_;
    private boolean checkedState_;

    HtmlRadioButtonInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        if (this.getAttributeDirect("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setRawValue(DEFAULT_VALUE);
        }
        this.checkedState_ = this.defaultCheckedState_ = this.hasAttribute("checked");
    }

    @Override
    public boolean isChecked() {
        return this.checkedState_;
    }

    @Override
    public void reset() {
        this.setChecked(this.defaultCheckedState_);
    }

    void setCheckedInternal(boolean isChecked) {
        this.checkedState_ = isChecked;
    }

    @Override
    public Page setChecked(boolean isChecked) {
        ScriptResult scriptResult;
        Page page = this.getPage();
        boolean changed = this.isChecked() != isChecked;
        this.checkedState_ = isChecked;
        if (isChecked) {
            HtmlForm form = this.getEnclosingForm();
            if (form != null) {
                form.setCheckedRadioButton(this);
            } else if (page != null && page.isHtmlPage()) {
                this.setCheckedForPage((HtmlPage)page);
            }
        }
        if (changed && (scriptResult = this.fireEvent("change")) != null && page != null) {
            page = page.getEnclosingWindow().getWebClient().getCurrentWindow().getEnclosedPage();
        }
        return page;
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        boolean changed = !this.isChecked();
        SgmlPage page = this.getPage();
        if (form != null) {
            form.setCheckedRadioButton(this);
        } else if (page != null && page.isHtmlPage()) {
            this.setCheckedForPage((HtmlPage)page);
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return changed;
    }

    private void setCheckedForPage(HtmlPage htmlPage) {
        String name = this.getNameAttribute();
        for (HtmlElement htmlElement : htmlPage.getHtmlElementDescendants()) {
            HtmlRadioButtonInput radioInput;
            if (!(htmlElement instanceof HtmlRadioButtonInput) || !name.equals((radioInput = (HtmlRadioButtonInput)htmlElement).getAttribute("name")) || radioInput.getEnclosingForm() != null) continue;
            if (radioInput == this) {
                this.setCheckedInternal(true);
                continue;
            }
            radioInput.setCheckedInternal(false);
        }
    }

    @Override
    protected void doClickFireChangeEvent() {
        HtmlRadioButtonInput.executeOnChangeHandlerIfAppropriate(this);
    }

    @Override
    protected void preventDefault() {
        this.checkedState_ = !this.checkedState_;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValue(defaultValue);
    }

    @Override
    public void setValue(String newValue) {
        super.setValue(newValue);
        super.setDefaultValue(newValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        this.setChecked(this.isDefaultChecked());
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void onAddedToPage() {
        super.onAddedToPage();
        this.setChecked(this.isChecked());
    }

    @Override
    protected Object getInternalValue() {
        return this.isChecked();
    }

    @Override
    void handleFocusLostValueChanged() {
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String qualifiedNameLC = StringUtils.toRootLowerCase(qualifiedName);
        if ("value".equals(qualifiedNameLC)) {
            super.setAttributeNS(namespaceURI, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
            this.setRawValue(attributeValue);
            return;
        }
        if ("checked".equals(qualifiedNameLC)) {
            this.checkedState_ = true;
        }
        super.setAttributeNS(namespaceURI, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    protected boolean propagateClickStateUpdateToParent() {
        return false;
    }

    @Override
    public boolean isValueMissingValidityState() {
        if (ATTRIBUTE_NOT_DEFINED == this.getAttributeDirect("required")) {
            return false;
        }
        if (ATTRIBUTE_NOT_DEFINED == this.getNameAttribute()) {
            return false;
        }
        String name = this.getNameAttribute();
        for (HtmlElement htmlElement : this.getPage().getHtmlElementDescendants()) {
            HtmlRadioButtonInput radioInput;
            if (!(htmlElement instanceof HtmlRadioButtonInput) || !name.equals((radioInput = (HtmlRadioButtonInput)htmlElement).getAttribute("name")) || !radioInput.isChecked()) continue;
            return false;
        }
        return true;
    }
}

