/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.cyberneko.xerces.util.XMLAttributesImpl;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.ElementFactory;
import org.htmlunit.html.HtmlAbbreviated;
import org.htmlunit.html.HtmlAcronym;
import org.htmlunit.html.HtmlAddress;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlArea;
import org.htmlunit.html.HtmlArticle;
import org.htmlunit.html.HtmlAside;
import org.htmlunit.html.HtmlAudio;
import org.htmlunit.html.HtmlBase;
import org.htmlunit.html.HtmlBaseFont;
import org.htmlunit.html.HtmlBidirectionalIsolation;
import org.htmlunit.html.HtmlBidirectionalOverride;
import org.htmlunit.html.HtmlBig;
import org.htmlunit.html.HtmlBlockQuote;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlBold;
import org.htmlunit.html.HtmlBreak;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlButtonInput;
import org.htmlunit.html.HtmlCanvas;
import org.htmlunit.html.HtmlCaption;
import org.htmlunit.html.HtmlCenter;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlCitation;
import org.htmlunit.html.HtmlCode;
import org.htmlunit.html.HtmlColorInput;
import org.htmlunit.html.HtmlData;
import org.htmlunit.html.HtmlDataList;
import org.htmlunit.html.HtmlDateInput;
import org.htmlunit.html.HtmlDateTimeLocalInput;
import org.htmlunit.html.HtmlDefinition;
import org.htmlunit.html.HtmlDefinitionDescription;
import org.htmlunit.html.HtmlDefinitionList;
import org.htmlunit.html.HtmlDefinitionTerm;
import org.htmlunit.html.HtmlDeletedText;
import org.htmlunit.html.HtmlDetails;
import org.htmlunit.html.HtmlDialog;
import org.htmlunit.html.HtmlDirectory;
import org.htmlunit.html.HtmlDivision;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlEmailInput;
import org.htmlunit.html.HtmlEmbed;
import org.htmlunit.html.HtmlEmphasis;
import org.htmlunit.html.HtmlExample;
import org.htmlunit.html.HtmlFieldSet;
import org.htmlunit.html.HtmlFigure;
import org.htmlunit.html.HtmlFigureCaption;
import org.htmlunit.html.HtmlFileInput;
import org.htmlunit.html.HtmlFont;
import org.htmlunit.html.HtmlFooter;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlFrame;
import org.htmlunit.html.HtmlFrameSet;
import org.htmlunit.html.HtmlHead;
import org.htmlunit.html.HtmlHeader;
import org.htmlunit.html.HtmlHeading1;
import org.htmlunit.html.HtmlHeading2;
import org.htmlunit.html.HtmlHeading3;
import org.htmlunit.html.HtmlHeading4;
import org.htmlunit.html.HtmlHeading5;
import org.htmlunit.html.HtmlHeading6;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlHorizontalRule;
import org.htmlunit.html.HtmlHtml;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlImageInput;
import org.htmlunit.html.HtmlInlineFrame;
import org.htmlunit.html.HtmlInlineQuotation;
import org.htmlunit.html.HtmlInsertedText;
import org.htmlunit.html.HtmlItalic;
import org.htmlunit.html.HtmlKeyboard;
import org.htmlunit.html.HtmlLabel;
import org.htmlunit.html.HtmlLayer;
import org.htmlunit.html.HtmlLegend;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlListItem;
import org.htmlunit.html.HtmlListing;
import org.htmlunit.html.HtmlMain;
import org.htmlunit.html.HtmlMap;
import org.htmlunit.html.HtmlMark;
import org.htmlunit.html.HtmlMarquee;
import org.htmlunit.html.HtmlMenu;
import org.htmlunit.html.HtmlMeta;
import org.htmlunit.html.HtmlMeter;
import org.htmlunit.html.HtmlMonthInput;
import org.htmlunit.html.HtmlNav;
import org.htmlunit.html.HtmlNoBreak;
import org.htmlunit.html.HtmlNoEmbed;
import org.htmlunit.html.HtmlNoFrames;
import org.htmlunit.html.HtmlNoLayer;
import org.htmlunit.html.HtmlNoScript;
import org.htmlunit.html.HtmlNumberInput;
import org.htmlunit.html.HtmlObject;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlOptionGroup;
import org.htmlunit.html.HtmlOrderedList;
import org.htmlunit.html.HtmlOutput;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlParagraph;
import org.htmlunit.html.HtmlParameter;
import org.htmlunit.html.HtmlPasswordInput;
import org.htmlunit.html.HtmlPicture;
import org.htmlunit.html.HtmlPlainText;
import org.htmlunit.html.HtmlPreformattedText;
import org.htmlunit.html.HtmlProgress;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlRangeInput;
import org.htmlunit.html.HtmlRb;
import org.htmlunit.html.HtmlResetInput;
import org.htmlunit.html.HtmlRp;
import org.htmlunit.html.HtmlRt;
import org.htmlunit.html.HtmlRtc;
import org.htmlunit.html.HtmlRuby;
import org.htmlunit.html.HtmlS;
import org.htmlunit.html.HtmlSample;
import org.htmlunit.html.HtmlScript;
import org.htmlunit.html.HtmlSearchInput;
import org.htmlunit.html.HtmlSection;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.HtmlSlot;
import org.htmlunit.html.HtmlSmall;
import org.htmlunit.html.HtmlSource;
import org.htmlunit.html.HtmlSpan;
import org.htmlunit.html.HtmlStrike;
import org.htmlunit.html.HtmlStrong;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.HtmlSubscript;
import org.htmlunit.html.HtmlSummary;
import org.htmlunit.html.HtmlSuperscript;
import org.htmlunit.html.HtmlSvg;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableBody;
import org.htmlunit.html.HtmlTableColumn;
import org.htmlunit.html.HtmlTableColumnGroup;
import org.htmlunit.html.HtmlTableDataCell;
import org.htmlunit.html.HtmlTableFooter;
import org.htmlunit.html.HtmlTableHeader;
import org.htmlunit.html.HtmlTableHeaderCell;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.html.HtmlTelInput;
import org.htmlunit.html.HtmlTeletype;
import org.htmlunit.html.HtmlTemplate;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.HtmlTextInput;
import org.htmlunit.html.HtmlTime;
import org.htmlunit.html.HtmlTimeInput;
import org.htmlunit.html.HtmlTitle;
import org.htmlunit.html.HtmlTrack;
import org.htmlunit.html.HtmlUnderlined;
import org.htmlunit.html.HtmlUnorderedList;
import org.htmlunit.html.HtmlUrlInput;
import org.htmlunit.html.HtmlVariable;
import org.htmlunit.html.HtmlVideo;
import org.htmlunit.html.HtmlWeekInput;
import org.htmlunit.html.HtmlWordBreak;
import org.htmlunit.html.UnknownElementFactory;
import org.htmlunit.util.OrderedFastHashMap;
import org.xml.sax.Attributes;

public class DefaultElementFactory
implements ElementFactory {
    private static final Log LOG = LogFactory.getLog(DefaultElementFactory.class);
    public static final List<String> SUPPORTED_TAGS_ = Collections.unmodifiableList(Arrays.asList("abbr", "acronym", "a", "address", "area", "article", "aside", "audio", "base", "basefont", "bdi", "bdo", "big", "blockquote", "body", "b", "br", "button", "canvas", "caption", "center", "cite", "code", "data", "datalist", "dfn", "dd", "del", "details", "dialog", "dir", "div", "dl", "dt", "embed", "em", "fieldset", "figcaption", "figure", "font", "form", "footer", "frame", "frameset", "head", "header", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "html", "iframe", "q", "img", "image", "input", "ins", "i", "kbd", "label", "layer", "legend", "listing", "li", "link", "main", "map", "mark", "marquee", "menu", "meta", "meter", "nav", "nobr", "noembed", "noframes", "nolayer", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "picture", "plaintext", "pre", "progress", "rb", "rp", "rt", "rtc", "ruby", "s", "samp", "script", "section", "select", "slot", "small", "source", "span", "strike", "strong", "style", "sub", "summary", "sup", "svg", "table", "col", "colgroup", "tbody", "td", "th", "tr", "textarea", "tfoot", "thead", "tt", "template", "time", "title", "track", "u", "ul", "var", "video", "wbr", "xmp"));

    @Override
    public HtmlElement createElement(SgmlPage page, String tagName, Attributes attributes) {
        return this.createElementNS(page, null, tagName, attributes);
    }

    @Override
    public HtmlElement createElementNS(SgmlPage page, String namespaceURI, String qualifiedName, Attributes attributes) {
        HtmlElement element;
        Map<String, DomAttr> attributeMap = DefaultElementFactory.toMap(page, attributes);
        int colonIndex = qualifiedName.indexOf(58);
        String tagName = colonIndex == -1 ? qualifiedName.toLowerCase(Locale.ROOT) : qualifiedName.substring(colonIndex + 1).toLowerCase(Locale.ROOT);
        switch (tagName) {
            case "abbr": {
                element = new HtmlAbbreviated(qualifiedName, page, attributeMap);
                break;
            }
            case "acronym": {
                element = new HtmlAcronym(qualifiedName, page, attributeMap);
                break;
            }
            case "address": {
                element = new HtmlAddress(qualifiedName, page, attributeMap);
                break;
            }
            case "a": {
                element = new HtmlAnchor(qualifiedName, page, attributeMap);
                break;
            }
            case "area": {
                element = new HtmlArea(qualifiedName, page, attributeMap);
                break;
            }
            case "article": {
                element = new HtmlArticle(qualifiedName, page, attributeMap);
                break;
            }
            case "aside": {
                element = new HtmlAside(qualifiedName, page, attributeMap);
                break;
            }
            case "audio": {
                element = new HtmlAudio(qualifiedName, page, attributeMap);
                break;
            }
            case "base": {
                element = new HtmlBase(qualifiedName, page, attributeMap);
                break;
            }
            case "basefont": {
                element = new HtmlBaseFont(qualifiedName, page, attributeMap);
                break;
            }
            case "bdi": {
                element = new HtmlBidirectionalIsolation(qualifiedName, page, attributeMap);
                break;
            }
            case "bdo": {
                element = new HtmlBidirectionalOverride(qualifiedName, page, attributeMap);
                break;
            }
            case "big": {
                element = new HtmlBig(qualifiedName, page, attributeMap);
                break;
            }
            case "blockquote": {
                element = new HtmlBlockQuote(qualifiedName, page, attributeMap);
                break;
            }
            case "body": {
                element = new HtmlBody(qualifiedName, page, attributeMap, false);
                if (!(page instanceof HtmlPage) || !page.getWebClient().isJavaScriptEngineEnabled()) break;
                element.getScriptableObject();
                break;
            }
            case "b": {
                element = new HtmlBold(qualifiedName, page, attributeMap);
                break;
            }
            case "br": {
                element = new HtmlBreak(qualifiedName, page, attributeMap);
                break;
            }
            case "button": {
                element = new HtmlButton(qualifiedName, page, attributeMap);
                break;
            }
            case "canvas": {
                element = new HtmlCanvas(qualifiedName, page, attributeMap);
                break;
            }
            case "caption": {
                element = new HtmlCaption(qualifiedName, page, attributeMap);
                break;
            }
            case "center": {
                element = new HtmlCenter(qualifiedName, page, attributeMap);
                break;
            }
            case "cite": {
                element = new HtmlCitation(qualifiedName, page, attributeMap);
                break;
            }
            case "code": {
                element = new HtmlCode(qualifiedName, page, attributeMap);
                break;
            }
            case "data": {
                element = new HtmlData(qualifiedName, page, attributeMap);
                break;
            }
            case "datalist": {
                element = new HtmlDataList(qualifiedName, page, attributeMap);
                break;
            }
            case "dfn": {
                element = new HtmlDefinition(qualifiedName, page, attributeMap);
                break;
            }
            case "dd": {
                element = new HtmlDefinitionDescription(qualifiedName, page, attributeMap);
                break;
            }
            case "dl": {
                element = new HtmlDefinitionList(qualifiedName, page, attributeMap);
                break;
            }
            case "dt": {
                element = new HtmlDefinitionTerm(qualifiedName, page, attributeMap);
                break;
            }
            case "del": {
                element = new HtmlDeletedText(qualifiedName, page, attributeMap);
                break;
            }
            case "details": {
                element = new HtmlDetails(qualifiedName, page, attributeMap);
                break;
            }
            case "dialog": {
                element = new HtmlDialog(qualifiedName, page, attributeMap);
                break;
            }
            case "dir": {
                element = new HtmlDirectory(qualifiedName, page, attributeMap);
                break;
            }
            case "div": {
                element = new HtmlDivision(qualifiedName, page, attributeMap);
                break;
            }
            case "embed": {
                element = new HtmlEmbed(qualifiedName, page, attributeMap);
                break;
            }
            case "em": {
                element = new HtmlEmphasis(qualifiedName, page, attributeMap);
                break;
            }
            case "xmp": {
                element = new HtmlExample(qualifiedName, page, attributeMap);
                break;
            }
            case "fieldset": {
                element = new HtmlFieldSet(qualifiedName, page, attributeMap);
                break;
            }
            case "figure": {
                element = new HtmlFigure(qualifiedName, page, attributeMap);
                break;
            }
            case "figcaption": {
                element = new HtmlFigureCaption(qualifiedName, page, attributeMap);
                break;
            }
            case "font": {
                element = new HtmlFont(qualifiedName, page, attributeMap);
                break;
            }
            case "form": {
                element = new HtmlForm(qualifiedName, page, attributeMap);
                break;
            }
            case "footer": {
                element = new HtmlFooter(qualifiedName, page, attributeMap);
                break;
            }
            case "frame": {
                DomAttr srcAttribute;
                if (attributeMap != null && (srcAttribute = attributeMap.get("src")) != null) {
                    srcAttribute.setValue(srcAttribute.getValue().trim());
                }
                element = new HtmlFrame(qualifiedName, page, attributeMap);
                break;
            }
            case "frameset": {
                element = new HtmlFrameSet(qualifiedName, page, attributeMap);
                break;
            }
            case "head": {
                element = new HtmlHead(qualifiedName, page, attributeMap);
                break;
            }
            case "header": {
                element = new HtmlHeader(qualifiedName, page, attributeMap);
                break;
            }
            case "h1": {
                element = new HtmlHeading1(qualifiedName, page, attributeMap);
                break;
            }
            case "h2": {
                element = new HtmlHeading2(qualifiedName, page, attributeMap);
                break;
            }
            case "h3": {
                element = new HtmlHeading3(qualifiedName, page, attributeMap);
                break;
            }
            case "h4": {
                element = new HtmlHeading4(qualifiedName, page, attributeMap);
                break;
            }
            case "h5": {
                element = new HtmlHeading5(qualifiedName, page, attributeMap);
                break;
            }
            case "h6": {
                element = new HtmlHeading6(qualifiedName, page, attributeMap);
                break;
            }
            case "hr": {
                element = new HtmlHorizontalRule(qualifiedName, page, attributeMap);
                break;
            }
            case "html": {
                element = new HtmlHtml(qualifiedName, page, attributeMap);
                break;
            }
            case "img": 
            case "image": {
                element = new HtmlImage(qualifiedName, page, attributeMap);
                break;
            }
            case "iframe": {
                DomAttr srcAttribute;
                if (attributeMap != null && (srcAttribute = attributeMap.get("src")) != null) {
                    srcAttribute.setValue(srcAttribute.getValue().trim());
                }
                element = new HtmlInlineFrame(qualifiedName, page, attributeMap);
                break;
            }
            case "q": {
                element = new HtmlInlineQuotation(qualifiedName, page, attributeMap);
                break;
            }
            case "input": {
                element = DefaultElementFactory.createInputElement(qualifiedName, page, attributeMap);
                break;
            }
            case "ins": {
                element = new HtmlInsertedText(qualifiedName, page, attributeMap);
                break;
            }
            case "i": {
                element = new HtmlItalic(qualifiedName, page, attributeMap);
                break;
            }
            case "kbd": {
                element = new HtmlKeyboard(qualifiedName, page, attributeMap);
                break;
            }
            case "label": {
                element = new HtmlLabel(qualifiedName, page, attributeMap);
                break;
            }
            case "layer": {
                if (page.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_LAYER_TAG)) {
                    element = new HtmlLayer(qualifiedName, page, attributeMap);
                    break;
                }
                element = UnknownElementFactory.INSTANCE.createElementNS(page, namespaceURI, qualifiedName, attributes);
                break;
            }
            case "legend": {
                element = new HtmlLegend(qualifiedName, page, attributeMap);
                break;
            }
            case "link": {
                element = new HtmlLink(qualifiedName, page, attributeMap);
                break;
            }
            case "listing": {
                element = new HtmlListing(qualifiedName, page, attributeMap);
                break;
            }
            case "li": {
                element = new HtmlListItem(qualifiedName, page, attributeMap);
                break;
            }
            case "main": {
                element = new HtmlMain(qualifiedName, page, attributeMap);
                break;
            }
            case "map": {
                element = new HtmlMap(qualifiedName, page, attributeMap);
                break;
            }
            case "mark": {
                element = new HtmlMark(qualifiedName, page, attributeMap);
                break;
            }
            case "marquee": {
                element = new HtmlMarquee(qualifiedName, page, attributeMap);
                break;
            }
            case "menu": {
                element = new HtmlMenu(qualifiedName, page, attributeMap);
                break;
            }
            case "meta": {
                element = new HtmlMeta(qualifiedName, page, attributeMap);
                break;
            }
            case "meter": {
                element = new HtmlMeter(qualifiedName, page, attributeMap);
                break;
            }
            case "nav": {
                element = new HtmlNav(qualifiedName, page, attributeMap);
                break;
            }
            case "nobr": {
                element = new HtmlNoBreak(qualifiedName, page, attributeMap);
                break;
            }
            case "noembed": {
                element = new HtmlNoEmbed(qualifiedName, page, attributeMap);
                break;
            }
            case "noframes": {
                element = new HtmlNoFrames(qualifiedName, page, attributeMap);
                break;
            }
            case "nolayer": {
                if (page.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_LAYER_TAG)) {
                    element = new HtmlNoLayer(qualifiedName, page, attributeMap);
                    break;
                }
                element = UnknownElementFactory.INSTANCE.createElementNS(page, namespaceURI, qualifiedName, attributes);
                break;
            }
            case "noscript": {
                element = new HtmlNoScript(qualifiedName, page, attributeMap);
                break;
            }
            case "object": {
                element = new HtmlObject(qualifiedName, page, attributeMap);
                break;
            }
            case "option": {
                element = new HtmlOption(qualifiedName, page, attributeMap);
                break;
            }
            case "optgroup": {
                element = new HtmlOptionGroup(qualifiedName, page, attributeMap);
                break;
            }
            case "ol": {
                element = new HtmlOrderedList(qualifiedName, page, attributeMap);
                break;
            }
            case "output": {
                element = new HtmlOutput(qualifiedName, page, attributeMap);
                break;
            }
            case "p": {
                element = new HtmlParagraph(qualifiedName, page, attributeMap);
                break;
            }
            case "param": {
                element = new HtmlParameter(qualifiedName, page, attributeMap);
                break;
            }
            case "picture": {
                element = new HtmlPicture(qualifiedName, page, attributeMap);
                break;
            }
            case "plaintext": {
                element = new HtmlPlainText(qualifiedName, page, attributeMap);
                break;
            }
            case "pre": {
                element = new HtmlPreformattedText(qualifiedName, page, attributeMap);
                break;
            }
            case "progress": {
                element = new HtmlProgress(qualifiedName, page, attributeMap);
                break;
            }
            case "rb": {
                element = new HtmlRb(qualifiedName, page, attributeMap);
                break;
            }
            case "rp": {
                element = new HtmlRp(qualifiedName, page, attributeMap);
                break;
            }
            case "rt": {
                element = new HtmlRt(qualifiedName, page, attributeMap);
                break;
            }
            case "rtc": {
                element = new HtmlRtc(qualifiedName, page, attributeMap);
                break;
            }
            case "ruby": {
                element = new HtmlRuby(qualifiedName, page, attributeMap);
                break;
            }
            case "s": {
                element = new HtmlS(qualifiedName, page, attributeMap);
                break;
            }
            case "samp": {
                element = new HtmlSample(qualifiedName, page, attributeMap);
                break;
            }
            case "script": {
                element = new HtmlScript(qualifiedName, page, attributeMap);
                break;
            }
            case "section": {
                element = new HtmlSection(qualifiedName, page, attributeMap);
                break;
            }
            case "select": {
                element = new HtmlSelect(qualifiedName, page, attributeMap);
                break;
            }
            case "small": {
                element = new HtmlSmall(qualifiedName, page, attributeMap);
                break;
            }
            case "slot": {
                element = new HtmlSlot(qualifiedName, page, attributeMap);
                break;
            }
            case "source": {
                element = new HtmlSource(qualifiedName, page, attributeMap);
                break;
            }
            case "span": {
                element = new HtmlSpan(qualifiedName, page, attributeMap);
                break;
            }
            case "strike": {
                element = new HtmlStrike(qualifiedName, page, attributeMap);
                break;
            }
            case "strong": {
                element = new HtmlStrong(qualifiedName, page, attributeMap);
                break;
            }
            case "style": {
                element = new HtmlStyle(qualifiedName, page, attributeMap);
                break;
            }
            case "sub": {
                element = new HtmlSubscript(qualifiedName, page, attributeMap);
                break;
            }
            case "summary": {
                element = new HtmlSummary(qualifiedName, page, attributeMap);
                break;
            }
            case "sup": {
                element = new HtmlSuperscript(qualifiedName, page, attributeMap);
                break;
            }
            case "svg": {
                element = new HtmlSvg(qualifiedName, page, attributeMap);
                break;
            }
            case "table": {
                element = new HtmlTable(qualifiedName, page, attributeMap);
                break;
            }
            case "tbody": {
                element = new HtmlTableBody(qualifiedName, page, attributeMap);
                break;
            }
            case "col": {
                element = new HtmlTableColumn(qualifiedName, page, attributeMap);
                break;
            }
            case "colgroup": {
                element = new HtmlTableColumnGroup(qualifiedName, page, attributeMap);
                break;
            }
            case "td": {
                element = new HtmlTableDataCell(qualifiedName, page, attributeMap);
                break;
            }
            case "tfoot": {
                element = new HtmlTableFooter(qualifiedName, page, attributeMap);
                break;
            }
            case "thead": {
                element = new HtmlTableHeader(qualifiedName, page, attributeMap);
                break;
            }
            case "th": {
                element = new HtmlTableHeaderCell(qualifiedName, page, attributeMap);
                break;
            }
            case "tr": {
                element = new HtmlTableRow(qualifiedName, page, attributeMap);
                break;
            }
            case "tt": {
                element = new HtmlTeletype(qualifiedName, page, attributeMap);
                break;
            }
            case "template": {
                element = new HtmlTemplate(qualifiedName, page, attributeMap);
                break;
            }
            case "textarea": {
                element = new HtmlTextArea(qualifiedName, page, attributeMap);
                break;
            }
            case "time": {
                element = new HtmlTime(qualifiedName, page, attributeMap);
                break;
            }
            case "title": {
                element = new HtmlTitle(qualifiedName, page, attributeMap);
                break;
            }
            case "track": {
                element = new HtmlTrack(qualifiedName, page, attributeMap);
                break;
            }
            case "u": {
                element = new HtmlUnderlined(qualifiedName, page, attributeMap);
                break;
            }
            case "ul": {
                element = new HtmlUnorderedList(qualifiedName, page, attributeMap);
                break;
            }
            case "var": {
                element = new HtmlVariable(qualifiedName, page, attributeMap);
                break;
            }
            case "video": {
                element = new HtmlVideo(qualifiedName, page, attributeMap);
                break;
            }
            case "wbr": {
                element = new HtmlWordBreak(qualifiedName, page, attributeMap);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot find HtmlElement for " + qualifiedName);
            }
        }
        return element;
    }

    static Map<String, DomAttr> toMap(SgmlPage page, Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        int length = attributes.getLength();
        if (length == 0) {
            return null;
        }
        OrderedFastHashMapWithLowercaseKeys<String, DomAttr> attributeMap = new OrderedFastHashMapWithLowercaseKeys<String, DomAttr>(length);
        if (attributes instanceof XMLAttributesImpl) {
            ArrayList attribs = ((XMLAttributesImpl)attributes).getAttributes();
            for (XMLAttributesImpl.Attribute attribute : attribs) {
                QName qName = attribute.getQName();
                String name = qName.getRawname();
                String namespaceURI = qName.getUri();
                if (namespaceURI != null && namespaceURI.isEmpty()) {
                    namespaceURI = null;
                }
                DomAttr attr = new DomAttr(page, namespaceURI, name, attribute.getValue(), true);
                if ((attr = attributeMap.put(name, attr)) == null) continue;
                attributeMap.put(name, attr);
            }
            return attributeMap;
        }
        for (int i = 0; i < length; ++i) {
            String qName = attributes.getQName(i);
            String namespaceURI = attributes.getURI(i);
            if (namespaceURI != null && namespaceURI.isEmpty()) {
                namespaceURI = null;
            }
            DomAttr attr = new DomAttr(page, namespaceURI, qName, attributes.getValue(i), true);
            if ((attr = attributeMap.put(qName, attr)) == null) continue;
            attributeMap.put(qName, attr);
        }
        return attributeMap;
    }

    private static HtmlElement createInputElement(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributeMap) {
        String type = "";
        if (attributeMap != null) {
            for (Map.Entry<String, DomAttr> entry : attributeMap.entrySet()) {
                if (!"type".equalsIgnoreCase(entry.getKey())) continue;
                type = entry.getValue().getValue();
            }
        }
        return switch (type.toLowerCase(Locale.ROOT)) {
            case "", "text" -> new HtmlTextInput(qualifiedName, page, attributeMap);
            case "submit" -> new HtmlSubmitInput(qualifiedName, page, attributeMap);
            case "checkbox" -> new HtmlCheckBoxInput(qualifiedName, page, attributeMap);
            case "radio" -> new HtmlRadioButtonInput(qualifiedName, page, attributeMap);
            case "hidden" -> new HtmlHiddenInput(qualifiedName, page, attributeMap);
            case "password" -> new HtmlPasswordInput(qualifiedName, page, attributeMap);
            case "image" -> new HtmlImageInput(qualifiedName, page, attributeMap);
            case "reset" -> new HtmlResetInput(qualifiedName, page, attributeMap);
            case "button" -> new HtmlButtonInput(qualifiedName, page, attributeMap);
            case "file" -> new HtmlFileInput(qualifiedName, page, attributeMap);
            case "color" -> new HtmlColorInput(qualifiedName, page, attributeMap);
            case "date" -> new HtmlDateInput(qualifiedName, page, attributeMap);
            case "datetime-local" -> new HtmlDateTimeLocalInput(qualifiedName, page, attributeMap);
            case "email" -> new HtmlEmailInput(qualifiedName, page, attributeMap);
            case "month" -> new HtmlMonthInput(qualifiedName, page, attributeMap);
            case "number" -> new HtmlNumberInput(qualifiedName, page, attributeMap);
            case "range" -> new HtmlRangeInput(qualifiedName, page, attributeMap);
            case "search" -> new HtmlSearchInput(qualifiedName, page, attributeMap);
            case "tel" -> new HtmlTelInput(qualifiedName, page, attributeMap);
            case "time" -> new HtmlTimeInput(qualifiedName, page, attributeMap);
            case "url" -> new HtmlUrlInput(qualifiedName, page, attributeMap);
            case "week" -> new HtmlWeekInput(qualifiedName, page, attributeMap);
            default -> {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Bad input type: \"" + type + "\", creating a text input"));
                }
                yield new HtmlTextInput(qualifiedName, page, attributeMap);
            }
        };
    }

    static final class OrderedFastHashMapWithLowercaseKeys<K, V>
    extends OrderedFastHashMap<K, V> {
        OrderedFastHashMapWithLowercaseKeys(int size) {
            super(size);
        }
    }
}

