/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.htmlunit.HttpMethod;
import org.htmlunit.Page;
import org.htmlunit.RefreshHandler;
import org.htmlunit.WebRequest;
import org.htmlunit.WebWindow;

public class ImmediateRefreshHandler
implements RefreshHandler,
Serializable {
    @Override
    public void handleRefresh(Page page, URL url, int seconds) throws IOException {
        WebWindow window = page.getEnclosingWindow();
        if (window == null) {
            return;
        }
        if (page.getUrl().toExternalForm().equals(url.toExternalForm()) && HttpMethod.GET == page.getWebResponse().getWebRequest().getHttpMethod()) {
            String msg = "Refresh to " + String.valueOf(url) + " (" + seconds + "s) aborted by HtmlUnit: Attempted to refresh a page using an ImmediateRefreshHandler which could have caused an OutOfMemoryError Please use WaitingRefreshHandler or ThreadedRefreshHandler instead.";
            throw new RuntimeException(msg);
        }
        window.getWebClient().getPage(window, new WebRequest(url));
    }
}

