/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import com.xceptance.common.lang.StringUtils;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.mastercontroller.TestCaseLoadProfileConfiguration;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javassist.bytecode.ClassFile;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.util.QueryBuilder;

public class TestCaseMapper {
    private static final String[] CLASS_DIRECTORIES = new String[]{"patches/classes", "classes", "target/classes", "target/test-classes", "build/classes/java/main", "build/classes/kotlin/main", "build/resources/main", "build/classes/java/test", "build/classes/kotlin/test", "build/resources/test", "bin"};
    private static final String[] JAR_DIRECTORIES = new String[]{"patches/lib", "lib", "target/dependency", "build/dependency"};
    private final Set<String> unmappedTestCaseNames = new HashSet<String>();

    public TestCaseMapper(TestLoadProfileConfiguration loadProfile) {
        for (TestCaseLoadProfileConfiguration config : loadProfile.getLoadTestConfiguration()) {
            if (config.getTestCaseClassName() != null && !config.getTestCaseClassName().isBlank()) continue;
            this.unmappedTestCaseNames.add(config.getUserName());
        }
    }

    public Set<String> getUnmappedTestCaseNames() {
        return this.unmappedTestCaseNames;
    }

    public Map<String, String> scanForTestCaseClassMappings(File workDir) throws XltException {
        HashMap<String, String> testCaseClassNameMappings = new HashMap<String, String>();
        if (!this.unmappedTestCaseNames.isEmpty()) {
            Set<String> matchingTestClassNames = this.scanForTestClasses(workDir);
            for (String testCaseName : this.unmappedTestCaseNames) {
                testCaseClassNameMappings.put(testCaseName, this.getSingleMatchingTestClassName(testCaseName, matchingTestClassNames));
            }
        }
        return testCaseClassNameMappings;
    }

    Set<String> scanForTestClasses(File workDir) {
        AllClassesScanner scanner = new AllClassesScanner(this);
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(TestCaseMapper.getUrlsToScan(workDir)).setScanners(new Scanner[]{scanner}).setExpandSuperTypes(false).filterInputsBy((Predicate)new FilterBuilder().includePattern(TestCaseMapper.getTestClassesFilePattern(this.unmappedTestCaseNames))));
        return reflections.get(scanner.of(new AnnotatedElement[]{Object.class}));
    }

    static Set<URL> getUrlsToScan(File workDir) throws XltException {
        File dir;
        HashSet<File> filesToScan = new HashSet<File>();
        for (String directoryPath : CLASS_DIRECTORIES) {
            dir = new File(workDir, directoryPath);
            if (!dir.isDirectory()) continue;
            filesToScan.add(dir);
        }
        for (String directoryPath : JAR_DIRECTORIES) {
            dir = new File(workDir, directoryPath);
            if (!dir.isDirectory()) continue;
            for (File file : dir.listFiles()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".JAR")) continue;
                filesToScan.add(file);
            }
        }
        if (filesToScan.isEmpty()) {
            throw new XltException("Auto-mapping test cases failed because no valid test class directories were found in '" + String.valueOf(workDir) + "'.");
        }
        return filesToScan.stream().map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new XltException("Failed to convert file '" + String.valueOf(f) + "' to URL.", e);
            }
        }).collect(Collectors.toSet());
    }

    private String getSingleMatchingTestClassName(String testCaseName, Set<String> testClassNames) throws XltException {
        Pattern testClassNamePattern = Pattern.compile(TestCaseMapper.getTestClassNamePattern(testCaseName));
        List matchingClassNames = testClassNames.stream().filter(testClassNamePattern.asPredicate()).collect(Collectors.toList());
        if (matchingClassNames.isEmpty()) {
            throw new XltException("Auto-mapping test cases failed because no matching test class was found for test case '" + testCaseName + "'.");
        }
        if (matchingClassNames.size() > 1) {
            throw new XltException("Auto-mapping test cases failed because multiple matching test classes were found for test case '" + testCaseName + "': [ " + StringUtils.join(", ", matchingClassNames, 5, ", ...") + " ].");
        }
        return (String)matchingClassNames.get(0);
    }

    static String getTestClassesFilePattern(Set<String> testCaseNames) {
        Set escapedTestCaseNames = testCaseNames.stream().map(Pattern::quote).collect(Collectors.toSet());
        return "(^|(.*(\\/|\\$)))(" + String.join((CharSequence)"|", escapedTestCaseNames) + ")\\.class$";
    }

    static String getTestClassNamePattern(String testCaseName) {
        return "(^|(.*(\\.|\\$)))" + Pattern.quote(testCaseName) + "$";
    }

    private class AllClassesScanner
    implements Scanner,
    QueryBuilder {
        private AllClassesScanner(TestCaseMapper testCaseMapper) {
        }

        public List<Map.Entry<String, String>> scan(ClassFile classFile) {
            return List.of(this.entry(Object.class.getName(), classFile.getName()));
        }

        public String index() {
            return this.getClass().getSimpleName();
        }
    }
}

