/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class SecretPropertiesMask
implements AutoCloseable {
    private final Reader reader;
    private final Writer writer;

    public SecretPropertiesMask(Reader reader, Writer writer) {
        this.reader = Objects.requireNonNull(reader);
        this.writer = Objects.requireNonNull(writer);
    }

    public void maskProperties(boolean maskAllProperties) throws IOException {
        PropertiesConfiguration.JupPropertiesReader propsReader = new PropertiesConfiguration.JupPropertiesReader(this.reader);
        PropertiesConfiguration.JupPropertiesWriter propsWriter = new PropertiesConfiguration.JupPropertiesWriter(this.writer, (ListDelimiterHandler)new DisabledListDelimiterHandler(), true);
        while (propsReader.nextProperty()) {
            List commentLines = propsReader.getCommentLines();
            if (commentLines != null) {
                for (String line : commentLines) {
                    propsWriter.writeln(line);
                }
            }
            String propName = propsReader.getPropertyName();
            String propValue = maskAllProperties || this.shouldMask(propName) ? "******" : propsReader.getPropertyValue();
            propsWriter.setCurrentSeparator(propsReader.getPropertySeparator());
            propsWriter.writeProperty(propName, (Object)propValue);
        }
        List remainder = propsReader.getCommentLines();
        if (remainder != null) {
            for (String line : remainder) {
                propsWriter.writeln(line);
            }
        }
    }

    protected boolean shouldMask(String key) {
        return StringUtils.startsWith((CharSequence)key, (CharSequence)"secret.");
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable[])new Closeable[]{this.reader, this.writer});
    }
}

