/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import com.xceptance.common.util.ParameterCheckUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.lang3.StringUtils;

public class PropertyFileHandler {
    private final File propertyFile;

    public PropertyFileHandler(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void setProperty(String propertyKey, String propertyValue) {
        if (StringUtils.isNotBlank((CharSequence)propertyKey) && StringUtils.isNotBlank((CharSequence)propertyValue)) {
            this.setProperties(Map.of(propertyKey, propertyValue));
        }
    }

    public void setProperties(Map<String, String> propertyMap) {
        ParameterCheckUtils.isNotNull(propertyMap, "propertyMap");
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory());
        FileHandler fileHandler = new FileHandler((FileBased)config);
        try {
            fileHandler.load(this.propertyFile);
            propertyMap.forEach((key, value) -> {
                if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
                    config.setProperty(key, value);
                }
            });
            fileHandler.save(this.propertyFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update the properties in '" + this.propertyFile.getName() + "'.", e);
        }
    }

    public void appendProperties(Map<String, String> propertyMap, String comment) {
        ParameterCheckUtils.isNotNull(propertyMap, "propertyMap");
        ArrayList<Object> linesToAppend = new ArrayList<Object>();
        propertyMap.forEach((key, value) -> {
            if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
                linesToAppend.add(key + " = " + value);
            }
        });
        Collections.sort(linesToAppend);
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            linesToAppend.addFirst("# " + comment);
        }
        linesToAppend.addFirst("");
        try {
            Files.write(this.propertyFile.toPath(), linesToAppend, StandardOpenOption.APPEND);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to append properties to file '" + this.propertyFile.getName() + "'.", e);
        }
    }
}

