/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.AbstractFixedSizeDoubleValueSet;
import java.util.Arrays;
import org.jfree.data.xy.XYIntervalSeries;

public class FixedSizeHistogramDoubleValueSet
extends AbstractFixedSizeDoubleValueSet {
    private final int[] countPerBucket;
    private int totalCount;

    public FixedSizeHistogramDoubleValueSet(int numberOfBuckets) {
        super(numberOfBuckets);
        this.countPerBucket = new int[numberOfBuckets];
    }

    @Override
    protected void scale() {
        int i;
        int numberOfBuckets = this.countPerBucket.length;
        int j = i = 0;
        while (i < numberOfBuckets) {
            this.countPerBucket[j] = this.countPerBucket[i] + this.countPerBucket[i + 1];
            i += 2;
            ++j;
        }
        Arrays.fill(this.countPerBucket, numberOfBuckets / 2, numberOfBuckets, 0);
    }

    @Override
    protected void shift(int buckets) {
        int numberOfBuckets = this.countPerBucket.length;
        for (int i = numberOfBuckets - 1; i >= 0; --i) {
            this.countPerBucket[i] = i >= buckets ? this.countPerBucket[i - buckets] : 0;
        }
    }

    @Override
    protected void storeValue(int index, double value) {
        int n = index;
        this.countPerBucket[n] = this.countPerBucket[n] + 1;
        ++this.totalCount;
    }

    int[] getCountPerBucket() {
        return this.countPerBucket;
    }

    public int getMaximumCount() {
        int maxCount = 0;
        for (int count : this.countPerBucket) {
            maxCount = Math.max(maxCount, count);
        }
        return maxCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public XYIntervalSeries toSeries(String seriesName) {
        XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)seriesName));
        double bucketWidth = this.getBucketWidth();
        double bucketStartValue = this.getMinimum();
        double bucketEndValue = bucketStartValue + bucketWidth;
        for (int i = 0; i < this.countPerBucket.length; ++i) {
            int count = this.countPerBucket[i];
            if (count > 0) {
                series.add((double)count, 0.0, (double)count, bucketEndValue, bucketStartValue, bucketEndValue);
            }
            bucketStartValue = bucketEndValue;
            bucketEndValue += bucketWidth;
        }
        return series;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.countPerBucket);
        result = 31 * result + this.totalCount;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedSizeHistogramDoubleValueSet other = (FixedSizeHistogramDoubleValueSet)obj;
        if (!Arrays.equals(this.countPerBucket, other.countPerBucket)) {
            return false;
        }
        return this.totalCount == other.totalCount;
    }
}

