/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.scorecard;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.xceptance.xlt.report.scorecard.Configuration;
import com.xceptance.xlt.report.scorecard.GroupDefinition;
import com.xceptance.xlt.report.scorecard.RuleDefinition;
import com.xceptance.xlt.report.scorecard.Status;
import com.xceptance.xlt.report.scorecard.TestFailTrigger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;

@XStreamAlias(value="scorecard")
public class Scorecard {
    public final Configuration configuration;
    @XStreamAlias(value="outcome")
    public final Result result = new Result();

    Scorecard(Configuration configuration) {
        this.configuration = configuration;
    }

    static Scorecard error(Throwable t) {
        Scorecard r = new Scorecard(null);
        String errMsg = ExceptionUtils.stream((Throwable)t).map(Throwable::getMessage).collect(Collectors.joining(" -> "));
        r.result.setError(errMsg);
        return r;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static class Result {
        @XStreamAsAttribute
        private Double pointsPercentage;
        @XStreamAsAttribute
        private Integer points;
        @XStreamAsAttribute
        private Integer totalPoints;
        @XStreamAsAttribute
        private boolean testFailed;
        private List<Group> groups;
        private String error;
        private String rating;

        public String getError() {
            return this.error;
        }

        void setError(String error) {
            this.error = Objects.requireNonNull(error);
        }

        public Integer getPoints() {
            return this.points;
        }

        void setPoints(Integer points) {
            this.points = points;
        }

        public Double getPointsPercentage() {
            return this.pointsPercentage;
        }

        void setPointsPercentage(Double pointsPercentage) {
            this.pointsPercentage = pointsPercentage;
        }

        public boolean isTestFailed() {
            return this.testFailed;
        }

        void setTestFailed(boolean testFailed) {
            this.testFailed = testFailed;
        }

        public Integer getTotalPoints() {
            return this.totalPoints;
        }

        void setTotalPoints(Integer totalPoints) {
            this.totalPoints = totalPoints;
        }

        void addGroup(Group group) {
            Objects.requireNonNull(group);
            if (this.groups == null) {
                this.groups = new LinkedList<Group>();
            }
            this.groups.add(group);
        }

        public List<Group> getGroups() {
            if (this.groups == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.groups);
        }

        public String getRating() {
            return this.rating;
        }

        void setRating(String rating) {
            this.rating = rating;
        }
    }

    @XStreamAlias(value="rule")
    public static class Rule {
        private final transient RuleDefinition definition;
        private final transient boolean groupEnabled;
        private final List<Check> checks = new LinkedList<Check>();
        @XStreamAlias(value="result")
        private Status status = Status.SKIPPED;
        private String message;
        @XStreamAsAttribute
        private int points;
        @XStreamAsAttribute
        @XStreamAlias(value="ref-id")
        private final String id;
        @XStreamAsAttribute
        private boolean testFailed;

        Rule(RuleDefinition definition, boolean groupEnabled) {
            this.definition = Objects.requireNonNull(definition, "Rule definition must not be null");
            this.groupEnabled = groupEnabled;
            this.id = definition.getId();
        }

        public String getId() {
            return this.id;
        }

        public RuleDefinition getDefinition() {
            return this.definition;
        }

        public List<Check> getChecks() {
            return Collections.unmodifiableList(this.checks);
        }

        void addCheck(Check check) {
            this.checks.add(Objects.requireNonNull(check));
        }

        public Status getStatus() {
            return this.status;
        }

        void setStatus(Status status) {
            this.status = Objects.requireNonNull(status);
        }

        public String getMessage() {
            return this.message;
        }

        void setMessage(String message) {
            this.message = StringUtils.trimToNull((String)message);
        }

        public int getPoints() {
            return this.points;
        }

        void setPoints(int points) {
            this.points = Math.max(0, Math.min(this.definition.getPoints(), points));
        }

        public boolean isEnabled() {
            return this.groupEnabled && this.definition.isEnabled();
        }

        TestFailTrigger getFailsOn() {
            return Optional.ofNullable(this.definition.getFailsOn()).orElse(TestFailTrigger.NOTPASSED);
        }

        boolean mayFailTest() {
            return this.isEnabled() && this.definition.isFailsTest() && this.getFailsOn().isTriggeredBy(this.status);
        }

        void setTestFailed() {
            this.testFailed = true;
        }

        @XStreamAlias(value="check")
        public static class Check {
            @XStreamAsAttribute
            private final int index;
            private final transient RuleDefinition.Check definition;
            private final transient boolean ruleEnabled;
            @XStreamAlias(value="result")
            private Status status = Status.SKIPPED;
            private String errorMessage;
            private String value;

            Check(RuleDefinition.Check definition, boolean ruleEnabled) {
                this.definition = Objects.requireNonNull(definition, "Check definition must not be null");
                this.ruleEnabled = ruleEnabled;
                this.index = definition.getIndex();
            }

            public int getIndex() {
                return this.index;
            }

            public RuleDefinition.Check getDefinition() {
                return this.definition;
            }

            public Status getStatus() {
                return this.status;
            }

            void setStatus(Status status) {
                this.status = Objects.requireNonNull(status);
            }

            public String getErrorMessage() {
                return this.errorMessage;
            }

            void setErrorMessage(String errorMessage) {
                this.errorMessage = StringUtils.trimToNull((String)errorMessage);
            }

            public String getValue() {
                return this.value;
            }

            void setValue(String value) {
                this.value = value;
            }

            public boolean isEnabled() {
                return this.ruleEnabled && this.definition.isEnabled();
            }
        }
    }

    @XStreamAlias(value="group")
    public static class Group {
        private final transient GroupDefinition definition;
        @XStreamAsAttribute
        @XStreamAlias(value="ref-id")
        private final String id;
        private final List<Rule> rules = new LinkedList<Rule>();
        @XStreamAsAttribute
        private int points;
        @XStreamAsAttribute
        private int totalPoints;
        private String message;
        @XStreamAlias(value="result")
        private Status status = Status.SKIPPED;
        @XStreamAsAttribute
        private boolean testFailed;

        Group(GroupDefinition definition) {
            this.definition = Objects.requireNonNull(definition, "Group definition must not be null");
            this.id = definition.getId();
        }

        public GroupDefinition getDefinition() {
            return this.definition;
        }

        public String getId() {
            return this.id;
        }

        public List<Rule> getRules() {
            return Collections.unmodifiableList(this.rules);
        }

        void addRule(Rule rule) {
            this.rules.add(Objects.requireNonNull(rule));
        }

        public int getPoints() {
            return this.points;
        }

        void setPoints(int points) {
            this.points = Math.max(0, points);
        }

        public int getTotalPoints() {
            return this.totalPoints;
        }

        void setTotalPoints(int totalPoints) {
            this.totalPoints = Math.max(0, totalPoints);
        }

        public String getMessage() {
            return this.message;
        }

        void setMessage(String message) {
            this.message = StringUtils.trimToNull((String)message);
        }

        void setStatus(Status status) {
            this.status = Objects.requireNonNull(status);
        }

        public Status getStatus() {
            return this.status;
        }

        void setTestFailed() {
            this.testFailed = true;
        }

        public boolean isEnabled() {
            return this.definition.isEnabled();
        }

        TestFailTrigger getFailsOn() {
            return Optional.ofNullable(this.definition.getFailsOn()).orElse(TestFailTrigger.NOTPASSED);
        }

        boolean mayFailTest() {
            return this.isEnabled() && this.definition.isFailsTest() && this.getFailsOn().isTriggeredBy(this.status);
        }
    }
}

