/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.SlowRequestReport;
import com.xceptance.xlt.report.providers.SlowestRequestsReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class SlowestRequestsReportProvider
extends AbstractReportProvider {
    private int requestsPerBucket;
    private int requestsTotal;
    private int minRuntime;
    private int maxRuntime;
    private final Map<String, TreeSet<SlowRequestReport>> slowestRequestsByBucket = new HashMap<String, TreeSet<SlowRequestReport>>();
    private long processingOrder = 0L;

    @Override
    public Object createReportFragment() {
        TreeSet<SlowRequestReport> slowestRequests = new TreeSet<SlowRequestReport>(SlowRequestReport.COMPARATOR);
        for (TreeSet<SlowRequestReport> bucketRequests : this.slowestRequestsByBucket.values()) {
            for (SlowRequestReport request : bucketRequests) {
                if (slowestRequests.size() < this.requestsTotal) {
                    slowestRequests.add(request);
                    continue;
                }
                if (request.runtime < slowestRequests.last().runtime) continue;
                slowestRequests.add(request);
                slowestRequests.remove(slowestRequests.last());
            }
        }
        SlowestRequestsReport report = new SlowestRequestsReport();
        report.slowestRequests = new ArrayList<SlowRequestReport>(slowestRequests);
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
        long runtime;
        if (data instanceof RequestData && (runtime = (long)((RequestData)data).getRunTime()) >= (long)this.minRuntime && runtime <= (long)this.maxRuntime) {
            String bucketName = data.getName();
            TreeSet<SlowRequestReport> requests = this.slowestRequestsByBucket.get(bucketName);
            if (requests == null) {
                requests = new TreeSet<SlowRequestReport>(SlowRequestReport.BUCKET_COMPARATOR);
                this.slowestRequestsByBucket.put(bucketName, requests);
            }
            if (requests.size() < this.requestsPerBucket) {
                requests.add(new SlowRequestReport((RequestData)data, this.processingOrder));
                ++this.processingOrder;
            } else if (runtime > requests.last().runtime) {
                requests.add(new SlowRequestReport((RequestData)data, this.processingOrder));
                ++this.processingOrder;
                requests.remove(requests.last());
            }
        }
    }

    @Override
    public void setConfiguration(ReportProviderConfiguration config) {
        super.setConfiguration(config);
        this.requestsPerBucket = ((ReportGeneratorConfiguration)config).getSlowestRequestsPerBucket();
        this.requestsTotal = ((ReportGeneratorConfiguration)config).getSlowestRequestsTotal();
        this.minRuntime = ((ReportGeneratorConfiguration)config).getSlowestRequestsMinRuntime();
        this.maxRuntime = ((ReportGeneratorConfiguration)config).getSlowestRequestsMaxRuntime();
        ParameterCheckUtils.isGreaterThan(this.requestsPerBucket, 0, "slowestRequestsPerBucket");
        ParameterCheckUtils.isGreaterThan(this.requestsTotal, 0, "slowestRequestsTotal");
        ParameterCheckUtils.isGreaterThan(this.minRuntime, 0, "slowRequestMinRuntime");
        ParameterCheckUtils.isGreaterThan(this.maxRuntime, 0, "slowRequestMaxRuntime");
        if (this.minRuntime > this.maxRuntime) {
            throw new IllegalArgumentException("'slowestRequestMinRuntime' must not be greater than 'slowestRequestMaxRuntime'");
        }
    }
}

