/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.xceptance.xlt.api.engine.RequestData;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;

@XStreamAlias(value="request")
public class SlowRequestReport {
    public final String name;
    public final long runtime;
    public final Date time;
    public final String requestId;
    public final String httpMethod;
    public final String url;
    public final String formDataEncoding;
    public final String formData;
    public final String responseId;
    public final int responseCode;
    public final String contentType;
    public final int bytesSent;
    public final int bytesReceived;
    public final int dnsTime;
    public final int connectTime;
    public final int sendTime;
    public final int serverBusyTime;
    public final int receiveTime;
    public final int timeToFirstBytes;
    public final int timeToLastBytes;
    public final String usedIpAddress;
    public final String[] ipAddresses;
    @XStreamOmitField
    private long processingOrder;
    @XStreamOmitField
    public static final Comparator<SlowRequestReport> COMPARATOR = (o1, o2) -> {
        int result = Long.compare(o2.runtime, o1.runtime);
        if (result == 0 && (result = o1.name.compareTo(o2.name)) == 0) {
            return Long.compare(o1.processingOrder, o2.processingOrder);
        }
        return result;
    };
    @XStreamOmitField
    public static final Comparator<SlowRequestReport> BUCKET_COMPARATOR = (o1, o2) -> {
        int result = Long.compare(o2.runtime, o1.runtime);
        if (result == 0) {
            return Long.compare(o1.processingOrder, o2.processingOrder);
        }
        return result;
    };

    public SlowRequestReport(RequestData requestData, long processingOrder) {
        this.name = requestData.getName();
        this.runtime = requestData.getRunTime();
        this.time = new Date(requestData.getTime());
        this.requestId = requestData.getRequestId();
        this.httpMethod = Objects.toString(requestData.getHttpMethod(), null);
        this.url = Objects.toString(requestData.getUrl(), null);
        this.formDataEncoding = Objects.toString(requestData.getFormDataEncoding(), null);
        this.formData = Objects.toString(requestData.getFormData(), null);
        this.responseId = requestData.getResponseId();
        this.responseCode = requestData.getResponseCode();
        this.contentType = Objects.toString(requestData.getContentType(), null);
        this.dnsTime = requestData.getDnsTime();
        this.connectTime = requestData.getConnectTime();
        this.sendTime = requestData.getSendTime();
        this.serverBusyTime = requestData.getServerBusyTime();
        this.receiveTime = requestData.getReceiveTime();
        this.timeToFirstBytes = requestData.getTimeToFirstBytes();
        this.timeToLastBytes = requestData.getTimeToLastBytes();
        this.bytesSent = requestData.getBytesSent();
        this.bytesReceived = requestData.getBytesReceived();
        this.ipAddresses = requestData.getIpAddresses();
        this.usedIpAddress = Objects.toString(requestData.getUsedIpAddress(), null);
        this.processingOrder = processingOrder;
    }
}

