/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.providers.ResponseCodeReport;
import com.xceptance.xlt.report.providers.ResponseCodesReport;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.report.util.ValueSet;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ResponseCodesReportProvider
extends AbstractReportProvider {
    private static final Color[] COLORS = new Color[]{new Color(15620650), new Color(3910896), new Color(3912778), new Color(0xD0D0D0), JFreeChartUtils.COLOR_EVENT, JFreeChartUtils.COLOR_ERROR};
    private final Map<Integer, ResponseCodeReport> responseCodeReports = new HashMap<Integer, ResponseCodeReport>();
    private final Map<Integer, ValueSet> responseCodeValueSets = new TreeMap<Integer, ValueSet>();

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof RequestData) {
            RequestData reqData = (RequestData)data;
            int code = reqData.getResponseCode();
            ResponseCodeReport responseCodeReport = this.responseCodeReports.get(code);
            if (responseCodeReport == null) {
                responseCodeReport = new ResponseCodeReport();
                responseCodeReport.code = code;
                responseCodeReport.statusText = this.getStatusText(code);
                this.responseCodeReports.put(code, responseCodeReport);
            }
            ++responseCodeReport.count;
            if (code >= 0 && code <= 599) {
                ValueSet responseCodeValueSet = this.responseCodeValueSets.computeIfAbsent(code, __ -> new ValueSet());
                responseCodeValueSet.addOrUpdateValue(reqData.getEndTime(), 1);
            }
        }
    }

    private String getStatusText(int statusCode) {
        String statusText;
        if (statusCode == 0) {
            statusText = "No Response Available";
        } else {
            try {
                statusText = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, null);
            }
            catch (IllegalArgumentException e) {
                statusText = null;
            }
            statusText = statusText == null ? "???" : statusText;
        }
        return statusText;
    }

    @Override
    public Object createReportFragment() {
        ResponseCodesReport report = new ResponseCodesReport();
        report.responseCodes = new ArrayList<ResponseCodeReport>(this.responseCodeReports.values());
        if (this.getConfiguration().shouldChartsGenerated()) {
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(() -> this.saveResponseCodesChart("Response Codes Per Second", "ResponseCodesPerSecond", this.responseCodeValueSets));
        }
        return report;
    }

    private void saveResponseCodesChart(String chartTitle, String chartFileName, Map<Integer, ValueSet> responseCodeValueSets) {
        JFreeChart chart = this.createResponseCodesChart(chartTitle, responseCodeValueSets);
        int height = responseCodeValueSets.size() * 75 + 100;
        JFreeChartUtils.saveChart(chart, chartFileName, this.getConfiguration().getChartDirectory(), this.getConfiguration().getChartWidth(), height);
    }

    private JFreeChart createResponseCodesChart(String chartTitle, Map<Integer, ValueSet> responseCodeValueSets) {
        TreeMap<String, Color> responseCodeGroups = new TreeMap<String, Color>();
        CombinedDomainXYPlot combinedPlot = JFreeChartUtils.createCombinedPlot(this.getConfiguration().getChartStartTime(), this.getConfiguration().getChartEndTime());
        for (Map.Entry<Integer, ValueSet> entry : responseCodeValueSets.entrySet()) {
            int n = entry.getKey();
            ValueSet responseCodeValueSet = entry.getValue();
            String responseCodeGroup = ResponseCodesReportProvider.determineResponseCodeGroup(n);
            Color responseCodeColor = ResponseCodesReportProvider.determineResponseCodeColor(n);
            responseCodeGroups.put(responseCodeGroup, responseCodeColor);
            TimeSeries responseCodeTimeSeries = JFreeChartUtils.toStandardTimeSeries(responseCodeValueSet.toMinMaxValueSet(this.getConfiguration().getChartWidth()), responseCodeGroup);
            XYPlot responseCodePlot = JFreeChartUtils.createBarPlot((XYDataset)new TimeSeriesCollection(responseCodeTimeSeries), null, "", responseCodeColor);
            NumberAxis fakeAxis = new NumberAxis(String.valueOf(n));
            fakeAxis.setTickMarksVisible(false);
            fakeAxis.setTickLabelsVisible(false);
            fakeAxis.setLabelAngle(4.71);
            fakeAxis.setLabelInsets(new RectangleInsets(0.0, 8.0, 0.0, 0.0));
            ValueAxis defaultAxis = responseCodePlot.getRangeAxis();
            responseCodePlot.setRangeAxes(new ValueAxis[]{defaultAxis, fakeAxis});
            combinedPlot.add(responseCodePlot, 1);
        }
        LegendItemCollection legendItems = new LegendItemCollection();
        for (Map.Entry entry : responseCodeGroups.entrySet()) {
            String responseCodeGroup = (String)entry.getKey();
            Color responseCodeColor = (Color)entry.getValue();
            legendItems.add(new LegendItem(responseCodeGroup, (Paint)responseCodeColor));
        }
        combinedPlot.setFixedLegendItems(legendItems);
        JFreeChart jFreeChart = JFreeChartUtils.createChart(chartTitle, (Plot)combinedPlot);
        return jFreeChart;
    }

    private static Color determineResponseCodeColor(int responseCode) {
        int group = responseCode / 100;
        return group >= 0 && group <= 5 ? COLORS[group] : null;
    }

    private static String determineResponseCodeGroup(int responseCode) {
        int group = responseCode / 100;
        return group >= 0 && group <= 5 ? String.valueOf(group) + "xx" : "Other";
    }
}

